/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.loader.loaders;

import java.util.concurrent.TimeUnit;
import org.apache.linkis.engineplugin.cache.EngineConnPluginCache;
import org.apache.linkis.engineplugin.cache.GuavaEngineConnPluginCache;
import org.apache.linkis.engineplugin.cache.refresh.PluginCacheRefresher;
import org.apache.linkis.engineplugin.loader.EngineConnPluginLoaderConf;
import org.apache.linkis.engineplugin.loader.loaders.EngineConnPluginsLoader;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInfo;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInstance;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheablesEngineConnPluginLoader
implements EngineConnPluginsLoader {
    protected EngineConnPluginCache pluginCache;
    private static final Logger LOG = LoggerFactory.getLogger(CacheablesEngineConnPluginLoader.class);

    public CacheablesEngineConnPluginLoader() {
        GuavaEngineConnPluginCache refreshablePluginCache = new GuavaEngineConnPluginCache();
        refreshablePluginCache.addRefreshListener(enginePluginInfo -> LOG.trace("Refresh engine conn plugin: [name: " + enginePluginInfo.typeLabel().getEngineType() + ", version: " + enginePluginInfo.typeLabel().getVersion() + ", resource_id: " + enginePluginInfo.resourceId() + ", resource_version: " + enginePluginInfo.resourceVersion() + ", resource_update_time: " + enginePluginInfo.resourceUpdateTime() + "]"));
        refreshablePluginCache.setRefresher(new PluginCacheRefresher(){

            @Override
            public long interval() {
                return Long.parseLong((String)EngineConnPluginLoaderConf.ENGINE_PLUGIN_LOADER_CACHE_REFRESH_INTERVAL().getValue());
            }

            @Override
            public TimeUnit timeUnit() {
                return TimeUnit.SECONDS;
            }
        });
        this.pluginCache = refreshablePluginCache;
    }

    @Override
    public EngineConnPluginInstance getEngineConnPlugin(EngineTypeLabel engineTypeLabel) throws Exception {
        EngineConnPluginInfo pluginInfo = new EngineConnPluginInfo(engineTypeLabel, -1L, null, null, null);
        return this.pluginCache.get(pluginInfo, this::loadEngineConnPluginInternal);
    }

    @Override
    public EngineConnPluginInstance loadEngineConnPlugin(EngineTypeLabel engineTypeLabel) throws Exception {
        EngineConnPluginInfo pluginInfo = new EngineConnPluginInfo(engineTypeLabel, -1L, null, null, null);
        EngineConnPluginInstance pluginInstance = this.loadEngineConnPluginInternal(pluginInfo);
        this.pluginCache.put(pluginInstance.info(), pluginInstance);
        return pluginInstance;
    }

    protected abstract EngineConnPluginInstance loadEngineConnPluginInternal(EngineConnPluginInfo var1) throws Exception;
}

