/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.entity.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.JsonUtils;
import org.apache.linkis.manager.label.entity.EMNodeLabel;
import org.apache.linkis.manager.label.entity.EngineNodeLabel;
import org.apache.linkis.manager.label.entity.Feature;
import org.apache.linkis.manager.label.entity.GenericLabel;
import org.apache.linkis.manager.label.entity.annon.ValueSerialNum;

public class EngineTypeLabel
extends GenericLabel
implements EngineNodeLabel,
EMNodeLabel {
    public EngineTypeLabel() {
        this.setLabelKey("engineType");
    }

    @Override
    public Feature getFeature() {
        return Feature.CORE;
    }

    public String getEngineType() {
        if (null == this.getValue()) {
            return null;
        }
        return (String)((Map)this.getValue()).get("engineType");
    }

    public String getVersion() {
        if (null == this.getValue()) {
            return null;
        }
        return (String)((Map)this.getValue()).get("version");
    }

    @ValueSerialNum(value=0)
    public void setEngineType(String type) {
        if (null == this.getValue()) {
            this.setValue((Map<String, String>)new HashMap<String, String>());
        }
        ((Map)this.getValue()).put("engineType", type);
    }

    @ValueSerialNum(value=1)
    public void setVersion(String version) {
        if (null == this.getValue()) {
            this.setValue((Map<String, String>)new HashMap<String, String>());
        }
        ((Map)this.getValue()).put("version", version);
    }

    @Override
    public Boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.getEngineType()) || StringUtils.isBlank((CharSequence)this.getVersion());
    }

    @Override
    public void setStringValue(String stringValue) {
        if (StringUtils.isNotBlank((CharSequence)stringValue)) {
            try {
                HashMap valueMap = (HashMap)JsonUtils.jackson().readValue(stringValue, HashMap.class);
                this.setEngineType((String)valueMap.get("engineType"));
                this.setVersion((String)valueMap.get("version"));
            }
            catch (JsonProcessingException e) {
                String engineType = stringValue.split("-")[0];
                String version = engineType.equals("*") ? stringValue.replaceFirst("[" + engineType + "]-", "") : stringValue.replaceFirst(engineType + "-", "");
                this.setEngineType(engineType);
                this.setVersion(version);
            }
        } else {
            this.setEngineType("*");
            this.setVersion("*");
        }
    }
}

