/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.File;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.tokenizer.CommandLineTokenizer;
import opennlp.tools.cmdline.tokenizer.TokenizerModelLoader;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenizerMETool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(TokenizerMETool.class);

    @Override
    public String getShortDescription() {
        return "Learnable tokenizer";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    @Override
    public void run(String[] args) {
        if (args.length != 1) {
            logger.info(this.getHelp());
        } else {
            TokenizerModel model = (TokenizerModel)new TokenizerModelLoader().load(new File(args[0]));
            CommandLineTokenizer tokenizer = new CommandLineTokenizer(new TokenizerME(model));
            tokenizer.process();
        }
    }
}

