/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.aop;

import java.util.List;
import org.springframework.integration.aop.MessageSourceMutator;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.file.remote.aop.RotationPolicy;
import org.springframework.integration.file.remote.aop.StandardRotationPolicy;
import org.springframework.integration.file.remote.session.DelegatingSessionFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class RotatingServerAdvice
implements MessageSourceMutator {
    private final RotationPolicy rotationPolicy;

    public RotatingServerAdvice(DelegatingSessionFactory<?> factory, List<RotationPolicy.KeyDirectory> keyDirectories) {
        this(factory, keyDirectories, false);
    }

    public RotatingServerAdvice(DelegatingSessionFactory<?> factory, List<RotationPolicy.KeyDirectory> keyDirectories, boolean fair) {
        this(new StandardRotationPolicy(factory, keyDirectories, fair));
    }

    public RotatingServerAdvice(RotationPolicy rotationPolicy) {
        Assert.notNull((Object)rotationPolicy, (String)"'rotationPolicy' cannot be null");
        this.rotationPolicy = rotationPolicy;
    }

    public boolean beforeReceive(MessageSource<?> source) {
        this.rotationPolicy.beforeReceive(source);
        return true;
    }

    @Nullable
    public Message<?> afterReceive(@Nullable Message<?> result, MessageSource<?> source) {
        this.rotationPolicy.afterReceive(result != null, source);
        return result;
    }
}

