/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import org.apache.myfaces.cdi.clientwindow.ClientWindowScopeContext;
import org.apache.myfaces.cdi.view.ViewScopeContext;
import org.apache.myfaces.context.ExceptionHandlerImpl;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.flow.cdi.FlowScopeContext;

public class MyFacesHttpSessionListener
implements HttpSessionListener {
    public static final String APPLICATION_MAP_KEY = MyFacesHttpSessionListener.class.getName();

    public void sessionCreated(HttpSessionEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            this.destroySessionDependentScopes(facesContext);
        } else {
            try {
                ServletContext servletContext = event.getSession().getServletContext();
                StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
                ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
                facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ExternalContext)externalContext, exceptionHandler, false);
                this.destroySessionDependentScopes(facesContext);
            }
            finally {
                if (facesContext != null) {
                    facesContext.release();
                }
            }
        }
    }

    protected void destroySessionDependentScopes(FacesContext facesContext) {
        FlowScopeContext.destroyAll(facesContext);
        ViewScopeContext.destroyAll(facesContext);
        ClientWindowScopeContext.destroyAll(facesContext);
    }
}

