/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.spi.editor.document;

import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.annotations.common.NonNull;

/**
 * Wrap undoable edits generated by document implementation into a custom undoable edit.
 * <br/>
 * Instances should be registered by using @MimeRegistration.
 *
 * @author Miloslav Metelka
 * @since 1.60
 */
public interface UndoableEditWrapper {
    
    /**
     * Wrap given undoable edit by a custom undoable edit implementation
     * (or leave it as it is).
     *
     * @param edit original undoable edit generated by document (or previous wrapper).
     * @param doc document which generated the original undoable edit.
     * @return wrap edit instance (delegating to the given edit) or original edit.
     */
    @NonNull UndoableEdit wrap(@NonNull UndoableEdit edit, @NonNull Document doc);
    
}
