/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.command;

import org.apache.nifi.minifi.bootstrap.MiNiFiParameters;
import org.apache.nifi.minifi.bootstrap.MiNiFiStatus;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.Status;
import org.apache.nifi.minifi.bootstrap.command.CommandRunner;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiStatusProvider;

public class StatusRunner
implements CommandRunner {
    private final MiNiFiParameters miNiFiParameters;
    private final MiNiFiStatusProvider miNiFiStatusProvider;

    public StatusRunner(MiNiFiParameters miNiFiParameters, MiNiFiStatusProvider miNiFiStatusProvider) {
        this.miNiFiParameters = miNiFiParameters;
        this.miNiFiStatusProvider = miNiFiStatusProvider;
    }

    @Override
    public int runCommand(String[] args) {
        return this.status();
    }

    private int status() {
        MiNiFiStatus status = this.miNiFiStatusProvider.getStatus(this.miNiFiParameters.getMiNiFiPort(), this.miNiFiParameters.getMinifiPid());
        if (status.isRespondingToPing()) {
            RunMiNiFi.CMD_LOGGER.info("Apache MiNiFi is currently running, listening to Bootstrap on port {}, PID={}", (Object)status.getPort(), status.getPid() == null ? "unknown" : status.getPid());
            return Status.OK.getStatusCode();
        }
        if (status.isProcessRunning()) {
            RunMiNiFi.CMD_LOGGER.info("Apache MiNiFi is running at PID {} but is not responding to ping requests", (Object)status.getPid());
            return Status.MINIFI_NOT_RESPONDING.getStatusCode();
        }
        if (status.getPort() == null) {
            RunMiNiFi.CMD_LOGGER.info("Apache MiNiFi is not running");
            return Status.MINIFI_NOT_RUNNING.getStatusCode();
        }
        if (status.getPid() == null) {
            RunMiNiFi.CMD_LOGGER.info("Apache MiNiFi is not responding to Ping requests. The process may have died or may be hung");
        } else {
            RunMiNiFi.CMD_LOGGER.info("Apache MiNiFi is not running");
        }
        return Status.MINIFI_NOT_RUNNING.getStatusCode();
    }
}

