/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema.v1;

import java.util.List;
import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.RemotePortSchema;
import org.apache.nifi.minifi.toolkit.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;

public class RemoteProcessGroupSchemaV1
extends BaseSchema
implements ConvertableSchema<RemoteProcessGroupSchema> {
    public static final String URL_KEY = "url";
    public static final String TIMEOUT_KEY = "timeout";
    public static final String DEFAULT_COMMENT = "";
    public static final String DEFAULT_TIMEOUT = "30 secs";
    public static final String DEFAULT_YIELD_PERIOD = "10 sec";
    private String name;
    private String url;
    private List<RemotePortSchema> inputPorts;
    private String comment = "";
    private String timeout = "30 secs";
    private String yieldPeriod = "10 sec";

    public RemoteProcessGroupSchemaV1(Map map) {
        this.name = this.getRequiredKeyAsType(map, "name", String.class, "Remote Process Groups");
        String wrapperName = "RemoteProcessingGroup(name: " + (StringUtil.isNullOrEmpty(this.name) ? "unknown" : this.name) + ")";
        this.url = this.getRequiredKeyAsType(map, URL_KEY, String.class, wrapperName);
        this.inputPorts = this.convertListToType(this.getRequiredKeyAsType(map, "Input Ports", List.class, wrapperName), "input port", RemotePortSchema.class, "Input Ports");
        if (this.inputPorts != null) {
            for (RemotePortSchema remoteInputPortSchema : this.inputPorts) {
                this.addIssuesIfNotNull(remoteInputPortSchema);
            }
        }
        this.comment = this.getOptionalKeyAsType(map, "comment", String.class, wrapperName, DEFAULT_COMMENT);
        this.timeout = this.getOptionalKeyAsType(map, TIMEOUT_KEY, String.class, wrapperName, DEFAULT_TIMEOUT);
        this.yieldPeriod = this.getOptionalKeyAsType(map, "yield period", String.class, wrapperName, DEFAULT_YIELD_PERIOD);
    }

    @Override
    public RemoteProcessGroupSchema convert() {
        Map result = (Map)this.mapSupplier.get();
        result.put("name", this.name);
        result.put(URL_KEY, this.url);
        result.put("comment", this.comment);
        result.put(TIMEOUT_KEY, this.timeout);
        result.put("yield period", this.yieldPeriod);
        RemoteProcessGroupSchemaV1.putListIfNotNull(result, "Input Ports", this.inputPorts);
        return new RemoteProcessGroupSchema(result);
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public String getYieldPeriod() {
        return this.yieldPeriod;
    }

    public List<RemotePortSchema> getInputPorts() {
        return this.inputPorts;
    }

    @Override
    public int getVersion() {
        return 1;
    }
}

