/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import java.util.EnumSet;
import org.jooq.Block;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.SQLDialect;
import org.jooq.Statement;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.Keywords;
import org.jooq.impl.NullStatement;
import org.jooq.impl.Tools;

final class BlockImpl
extends AbstractQuery
implements Block {
    private static final long serialVersionUID = 6881305779639901498L;
    private static final EnumSet<SQLDialect> REQUIRES_EXECUTE_IMMEDIATE_ON_DDL = EnumSet.of(SQLDialect.FIREBIRD);
    private static final EnumSet<SQLDialect> SUPPORTS_NULL_STATEMENT = EnumSet.of(SQLDialect.POSTGRES);
    private final Collection<? extends Statement> statements;

    BlockImpl(Configuration configuration, Collection<? extends Statement> statements) {
        super(configuration);
        this.statements = statements;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                if (Tools.increment(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) {
                    ctx.paramType(ParamType.INLINED).visit(Keywords.K_EXECUTE_BLOCK).sql(' ').visit(Keywords.K_AS).sql(' ').formatSeparator();
                    ctx.data((Object)Tools.DataKey.DATA_FORCE_STATIC_STATEMENT, true);
                }
                this.accept0(ctx);
                Tools.decrement(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING);
                break;
            }
            case POSTGRES: {
                if (Tools.increment(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) {
                    ctx.paramType(ParamType.INLINED).visit(Keywords.K_DO).sql(" $$").formatSeparator();
                    ctx.data((Object)Tools.DataKey.DATA_FORCE_STATIC_STATEMENT, true);
                }
                this.accept0(ctx);
                if (!Tools.decrement(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) break;
                ctx.formatSeparator().sql("$$");
                break;
            }
            default: {
                this.accept0(ctx);
            }
        }
    }

    private final void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_BEGIN);
        if (ctx.family() == SQLDialect.MARIADB) {
            ctx.sql(' ').visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_ATOMIC);
        }
        ctx.formatIndentStart();
        if (this.statements.isEmpty()) {
            switch (ctx.family()) {
                default: 
            }
        } else {
            for (Statement statement : this.statements) {
                if (statement instanceof NullStatement && !SUPPORTS_NULL_STATEMENT.contains((Object)ctx.family())) continue;
                ctx.formatSeparator();
                ctx.visit(statement);
                if (statement instanceof Block) continue;
                ctx.sql(';');
            }
        }
        ctx.formatIndentEnd().formatSeparator().visit(Keywords.K_END);
        switch (ctx.family()) {
            case FIREBIRD: {
                break;
            }
            default: {
                ctx.sql(';');
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

