/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Serializable;
import org.jooq.Configuration;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordType;
import org.jooq.impl.DefaultRecordMapper;
import org.jooq.impl.Tools;

public class DefaultRecordMapperProvider
implements RecordMapperProvider,
Serializable {
    private static final long serialVersionUID = -5333521849740568028L;
    private final Configuration configuration;

    public DefaultRecordMapperProvider() {
        this(null);
    }

    protected DefaultRecordMapperProvider(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public final <R extends Record, E> RecordMapper<R, E> provide(final RecordType<R> rowType, final Class<? extends E> type) {
        if (Boolean.TRUE.equals(this.configuration.settings().isCacheRecordMappers())) {
            return (RecordMapper)Tools.Cache.run(this.configuration, new Tools.Cache.CachedOperation<RecordMapper<R, E>>(){

                @Override
                public RecordMapper<R, E> call() {
                    return new DefaultRecordMapper(rowType, type, DefaultRecordMapperProvider.this.configuration);
                }
            }, Tools.DataCacheKey.DATA_CACHE_RECORD_MAPPERS, Tools.Cache.key(rowType, type));
        }
        return new DefaultRecordMapper<R, E>(rowType, type, this.configuration);
    }
}

