/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.safemode.AbstractContainerSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.server.events.EventQueue;

public class ECContainerSafeModeRule
extends AbstractContainerSafeModeRule {
    private final Map<ContainerID, Map<DatanodeID, DatanodeID>> ecContainerDNsMap = new ConcurrentHashMap<ContainerID, Map<DatanodeID, DatanodeID>>();

    public ECContainerSafeModeRule(EventQueue eventQueue, ConfigurationSource conf, ContainerManager containerManager, SCMSafeModeManager manager) {
        super(conf, manager, containerManager, eventQueue);
    }

    @Override
    protected HddsProtos.ReplicationType getContainerType() {
        return HddsProtos.ReplicationType.EC;
    }

    @Override
    protected void handleReportedContainer(ContainerID containerID, DatanodeID datanodeID) {
        if (this.getContainers().containsKey(containerID)) {
            Map replicas = this.ecContainerDNsMap.computeIfAbsent(containerID, key -> new ConcurrentHashMap());
            replicas.put(datanodeID, datanodeID);
            if (replicas.size() >= this.getMinReplica(containerID)) {
                this.getContainers().remove(containerID);
                this.incrementContainersWithMinReplicas();
                this.getSafeModeMetrics().incCurrentContainersWithECDataReplicaReportedCount();
            }
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.ecContainerDNsMap.clear();
    }
}

