/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.reconfig;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.admin.reconfig.AbstractReconfigureSubCommand;
import org.apache.hadoop.ozone.admin.reconfig.ReconfigureSubCommandUtil;
import picocli.CommandLine;

@CommandLine.Command(name="properties", description={"List reconfigurable properties"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ReconfigurePropertiesSubcommand
extends AbstractReconfigureSubCommand {
    @Override
    protected void executeCommand(HddsProtos.NodeType nodeType, String address) {
        try (ReconfigureProtocol reconfigProxy = ReconfigureSubCommandUtil.getSingleNodeReconfigureProxy(nodeType, address);){
            String serverName = reconfigProxy.getServerName();
            List properties = reconfigProxy.listReconfigureProperties();
            System.out.printf("%s: Node [%s] Reconfigurable properties:%n", serverName, address);
            for (String name : properties) {
                System.out.println(name);
            }
        }
        catch (IOException e) {
            System.out.println("An error occurred while executing the command for :" + address);
            throw new RuntimeException(e);
        }
    }
}

