/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.proxy;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.ratis.ServerNotLeaderException;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeInfo;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.scm.proxy.SCMProxyInfo;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;

public abstract class SCMFailoverProxyProviderBase<T>
implements FailoverProxyProvider<T> {
    private final SCMClientConfig scmClientConfig;
    private final Class<T> protocolClass;
    private final Map<String, FailoverProxyProvider.ProxyInfo<T>> scmProxies;
    private final Map<String, SCMProxyInfo> scmProxyInfoMap;
    private List<String> scmNodeIds;
    private volatile String currentProxySCMNodeId;
    private volatile int currentProxyIndex;
    private final ConfigurationSource conf;
    private final long scmVersion;
    private final int maxRetryCount;
    private final long retryInterval;
    private final UserGroupInformation ugi;
    private String updatedLeaderNodeID = null;

    public SCMFailoverProxyProviderBase(Class<T> protocol, ConfigurationSource conf, UserGroupInformation userGroupInformation) {
        this.protocolClass = protocol;
        this.conf = conf;
        if (userGroupInformation == null) {
            try {
                this.ugi = UserGroupInformation.getCurrentUser();
            }
            catch (IOException ex) {
                this.getLogger().error("Unable to fetch user credentials from UGI", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        } else {
            this.ugi = userGroupInformation;
        }
        this.scmVersion = RPC.getProtocolVersion(protocol);
        this.scmProxies = new HashMap<String, FailoverProxyProvider.ProxyInfo<T>>();
        this.scmProxyInfoMap = new HashMap<String, SCMProxyInfo>();
        this.loadConfigs();
        this.currentProxyIndex = 0;
        this.currentProxySCMNodeId = this.scmNodeIds.get(this.currentProxyIndex);
        this.scmClientConfig = (SCMClientConfig)conf.getObject(SCMClientConfig.class);
        this.maxRetryCount = this.scmClientConfig.getRetryCount();
        this.retryInterval = this.scmClientConfig.getRetryInterval();
        this.getLogger().info("Created fail-over proxy for protocol {} with {} nodes: {}", new Object[]{protocol.getSimpleName(), this.scmNodeIds.size(), this.scmProxyInfoMap.values()});
    }

    protected abstract Logger getLogger();

    protected abstract String getProtocolAddress(SCMNodeInfo var1);

    protected synchronized String getCurrentProxySCMNodeId() {
        return this.currentProxySCMNodeId;
    }

    @VisibleForTesting
    protected synchronized void loadConfigs() {
        List scmNodeInfoList = SCMNodeInfo.buildNodeInfo((ConfigurationSource)this.conf);
        this.scmNodeIds = new ArrayList<String>();
        for (SCMNodeInfo scmNodeInfo : scmNodeInfoList) {
            String protocolAddress = this.getProtocolAddress(scmNodeInfo);
            if (protocolAddress == null) {
                throw new ConfigurationException(this.protocolClass.getSimpleName() + " SCM Address could not be obtained from config. Config is not properly defined");
            }
            InetSocketAddress protocolAddr = NetUtils.createSocketAddr((String)protocolAddress);
            String scmServiceId = scmNodeInfo.getServiceId();
            String scmNodeId = scmNodeInfo.getNodeId();
            this.scmNodeIds.add(scmNodeId);
            SCMProxyInfo scmProxyInfo = new SCMProxyInfo(scmServiceId, scmNodeId, protocolAddr);
            this.scmProxyInfoMap.put(scmNodeId, scmProxyInfo);
        }
    }

    @VisibleForTesting
    public synchronized void changeCurrentProxy(String nodeId) {
        this.currentProxyIndex = this.scmNodeIds.indexOf(nodeId);
        this.currentProxySCMNodeId = nodeId;
        this.nextProxyIndex();
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        FailoverProxyProvider.ProxyInfo<T> currentProxyInfo = this.scmProxies.get(this.getCurrentProxySCMNodeId());
        if (currentProxyInfo == null) {
            currentProxyInfo = this.createSCMProxy(this.getCurrentProxySCMNodeId());
        }
        return currentProxyInfo;
    }

    public synchronized List<T> getProxies() {
        for (SCMProxyInfo scmProxyInfo : this.scmProxyInfoMap.values()) {
            if (this.scmProxies.get(scmProxyInfo.getNodeId()) != null) continue;
            this.scmProxies.put(scmProxyInfo.getNodeId(), this.createSCMProxy(scmProxyInfo.getNodeId()));
        }
        return this.scmProxies.values().stream().map(proxyInfo -> proxyInfo.proxy).collect(Collectors.toList());
    }

    public synchronized void performFailover(T newLeader) {
        if (this.updatedLeaderNodeID != null) {
            this.currentProxySCMNodeId = this.updatedLeaderNodeID;
        } else {
            this.nextProxyIndex();
        }
        this.getLogger().debug("Failing over to next proxy. {}", (Object)this.getCurrentProxySCMNodeId());
    }

    public synchronized void performFailoverToAssignedLeader(String newLeader, Exception e) {
        ServerNotLeaderException snle = (ServerNotLeaderException)SCMHAUtils.getServerNotLeaderException(e);
        if (snle != null && snle.getSuggestedLeader() != null) {
            Optional<SCMProxyInfo> matchedProxyInfo = this.scmProxyInfoMap.values().stream().filter(proxyInfo -> NetUtils.getHostPortString((InetSocketAddress)proxyInfo.getAddress()).equals(snle.getSuggestedLeader())).findFirst();
            if (matchedProxyInfo.isPresent()) {
                newLeader = matchedProxyInfo.get().getNodeId();
                this.getLogger().debug("Performing failover to suggested leader {}, nodeId {}", (Object)snle.getSuggestedLeader(), (Object)newLeader);
            } else {
                this.getLogger().debug("Suggested leader {} does not match with any of the proxyInfo address {}", (Object)snle.getSuggestedLeader(), (Object)Arrays.toString(this.scmProxyInfoMap.values().toArray()));
            }
        }
        this.assignLeaderToNode(newLeader);
    }

    public Class<T> getInterface() {
        return this.protocolClass;
    }

    public List<String> getSCMNodeIds() {
        return Collections.unmodifiableList(this.scmNodeIds);
    }

    public Collection<SCMProxyInfo> getSCMProxyInfoList() {
        return Collections.unmodifiableCollection(this.scmProxyInfoMap.values());
    }

    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo<T> proxy : this.scmProxies.values()) {
            Object scmProxy = proxy.proxy;
            if (scmProxy == null) continue;
            RPC.stopProxy((Object)scmProxy);
        }
    }

    private long getRetryInterval() {
        return this.retryInterval;
    }

    private synchronized void nextProxyIndex() {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.scmProxyInfoMap.size();
        this.currentProxySCMNodeId = this.scmNodeIds.get(this.currentProxyIndex);
    }

    private synchronized void assignLeaderToNode(String newLeaderNodeId) {
        if (!this.currentProxySCMNodeId.equals(newLeaderNodeId)) {
            if (this.scmProxyInfoMap.containsKey(newLeaderNodeId)) {
                this.updatedLeaderNodeID = newLeaderNodeId;
                this.getLogger().debug("Updated LeaderNodeID {}", (Object)this.updatedLeaderNodeID);
            } else {
                this.updatedLeaderNodeID = null;
            }
        }
    }

    private FailoverProxyProvider.ProxyInfo<T> createSCMProxy(String nodeId) {
        SCMProxyInfo scmProxyInfo = this.scmProxyInfoMap.get(nodeId);
        InetSocketAddress address = scmProxyInfo.getAddress();
        try {
            T scmProxy = this.createSCMProxy(address);
            FailoverProxyProvider.ProxyInfo proxyInfo = new FailoverProxyProvider.ProxyInfo(scmProxy, scmProxyInfo.toString());
            this.scmProxies.put(nodeId, proxyInfo);
            return proxyInfo;
        }
        catch (IOException ioe) {
            this.getLogger().error("{} Failed to create RPC proxy to SCM at {}", new Object[]{this.getClass().getSimpleName(), address, ioe});
            throw new RuntimeException(ioe);
        }
    }

    private T createSCMProxy(InetSocketAddress scmAddress) throws IOException {
        Configuration hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
        RPC.setProtocolEngine((Configuration)hadoopConf, this.protocolClass, ProtobufRpcEngine.class);
        RetryPolicy connectionRetryPolicy = RetryPolicies.failoverOnNetworkException((int)0);
        return (T)RPC.getProtocolProxy(this.protocolClass, (long)this.scmVersion, (InetSocketAddress)scmAddress, (UserGroupInformation)this.ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf), (int)((int)this.scmClientConfig.getRpcTimeOut()), (RetryPolicy)connectionRetryPolicy).getProxy();
    }

    public RetryPolicy getRetryPolicy() {
        return new RetryPolicy(){

            public RetryPolicy.RetryAction shouldRetry(Exception e, int retry, int failover, boolean b) {
                if (SCMFailoverProxyProviderBase.this.getLogger().isDebugEnabled()) {
                    if (e.getCause() != null) {
                        SCMFailoverProxyProviderBase.this.getLogger().debug("RetryProxy: SCM Server {}: {}: {}", new Object[]{SCMFailoverProxyProviderBase.this.getCurrentProxySCMNodeId(), e.getCause().getClass().getSimpleName(), e.getCause().getMessage()});
                    } else {
                        SCMFailoverProxyProviderBase.this.getLogger().debug("RetryProxy: SCM {}: {}", (Object)SCMFailoverProxyProviderBase.this.getCurrentProxySCMNodeId(), (Object)e.getMessage());
                    }
                }
                if (SCMHAUtils.checkRetriableWithNoFailoverException(e)) {
                    SCMFailoverProxyProviderBase.this.setUpdatedLeaderNodeID();
                } else {
                    SCMFailoverProxyProviderBase.this.performFailoverToAssignedLeader(null, e);
                }
                return SCMHAUtils.getRetryAction(failover, retry, e, SCMFailoverProxyProviderBase.this.maxRetryCount, SCMFailoverProxyProviderBase.this.getRetryInterval());
            }
        };
    }

    public synchronized void setUpdatedLeaderNodeID() {
        this.updatedLeaderNodeID = this.getCurrentProxySCMNodeId();
    }
}

