/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.AvailableSpaceFilter;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeChoosingUtil;
import org.apache.hadoop.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinVolumeChoosingPolicy
implements VolumeChoosingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(RoundRobinVolumeChoosingPolicy.class);
    private int nextVolumeIndex = 0;

    @Override
    public synchronized HddsVolume chooseVolume(List<HddsVolume> volumes, long maxContainerSize) throws IOException {
        int currentVolumeIndex;
        if (volumes.isEmpty()) {
            throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
        }
        AvailableSpaceFilter filter = new AvailableSpaceFilter(maxContainerSize);
        int startVolumeIndex = currentVolumeIndex = this.nextVolumeIndex < volumes.size() ? this.nextVolumeIndex : 0;
        while (true) {
            HddsVolume volume = volumes.get(currentVolumeIndex);
            boolean hasEnoughSpace = filter.test(volume);
            currentVolumeIndex = (currentVolumeIndex + 1) % volumes.size();
            if (hasEnoughSpace) {
                VolumeChoosingUtil.logIfSomeVolumesOutOfSpace(filter, LOG);
                this.nextVolumeIndex = currentVolumeIndex;
                volume.incCommittedBytes(maxContainerSize);
                return volume;
            }
            if (currentVolumeIndex != startVolumeIndex) continue;
            VolumeChoosingUtil.throwDiskOutOfSpace(filter, LOG);
        }
    }
}

