/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.s3;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.s3.S3Handler;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="getsecret", aliases={"get-secret"}, description={"Creates S3 secret for a user"})
public class GetS3SecretHandler
extends S3Handler {
    @CommandLine.Option(names={"-u"}, description={"Specify the user (accessId). Requires admin privilege'"})
    private String username;
    @CommandLine.Option(names={"-e"}, description={"Print out variables together with 'export' prefix, to use it from 'eval $(ozone s3 getsecret)'"})
    private boolean export;

    @Override
    protected boolean isApplicable() {
        return this.securityEnabled();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        if (this.username == null || this.username.isEmpty()) {
            this.username = UserGroupInformation.getCurrentUser().getUserName();
        }
        S3SecretValue secret = client.getObjectStore().getS3Secret(this.username);
        if (this.export) {
            this.out().println("export AWS_ACCESS_KEY_ID='" + secret.getAwsAccessKey() + "'");
            this.out().println("export AWS_SECRET_ACCESS_KEY='" + secret.getAwsSecret() + "'");
        } else {
            this.out().println(secret);
        }
    }
}

