/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;

@Metrics(about="OzoneManager HA Metrics", context="ozone")
public final class OMHAMetrics
implements MetricsSource {
    public static final String SOURCE_NAME = OMHAMetrics.class.getSimpleName();
    private final OMHAMetricsInfo omhaMetricsInfo = new OMHAMetricsInfo();
    private MetricsRegistry metricsRegistry;
    private String currNodeId;
    private String leaderId;

    private OMHAMetrics(String currNodeId, String leaderId) {
        this.currNodeId = currNodeId;
        this.leaderId = leaderId;
        this.metricsRegistry = new MetricsRegistry(SOURCE_NAME);
    }

    public static OMHAMetrics create(String nodeId, String leaderId) {
        OMHAMetrics metrics = new OMHAMetrics(nodeId, leaderId);
        return (OMHAMetrics)DefaultMetricsSystem.instance().register(SOURCE_NAME, "Metrics for OM HA", (Object)metrics);
    }

    public static void unRegister() {
        DefaultMetricsSystem.instance().unregisterSource(SOURCE_NAME);
    }

    public synchronized void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME);
        int state = this.currNodeId.equals(this.leaderId) ? 1 : 0;
        this.omhaMetricsInfo.setNodeId(this.currNodeId);
        this.omhaMetricsInfo.setOzoneManagerHALeaderState(state);
        recordBuilder.tag(OMHAMetricsInfo.NODE_ID, this.currNodeId).addGauge(OMHAMetricsInfo.OZONE_MANAGER_HA_LEADER_STATE, state);
        recordBuilder.endRecord();
    }

    @VisibleForTesting
    public String getOmhaInfoNodeId() {
        return this.omhaMetricsInfo.getNodeId();
    }

    @VisibleForTesting
    public int getOmhaInfoOzoneManagerHALeaderState() {
        return this.omhaMetricsInfo.getOzoneManagerHALeaderState();
    }

    private static final class OMHAMetricsInfo {
        private static final MetricsInfo OZONE_MANAGER_HA_LEADER_STATE = Interns.info((String)"OzoneManagerHALeaderState", (String)"Leader active state of OzoneManager node (1 leader, 0 follower)");
        private static final MetricsInfo NODE_ID = Interns.info((String)"NodeId", (String)"OM node Id");
        private int ozoneManagerHALeaderState = 0;
        private String nodeId = "";

        OMHAMetricsInfo() {
        }

        public int getOzoneManagerHALeaderState() {
            return this.ozoneManagerHALeaderState;
        }

        public void setOzoneManagerHALeaderState(int ozoneManagerHALeaderState) {
            this.ozoneManagerHALeaderState = ozoneManagerHALeaderState;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }
    }
}

