/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.collect.Lists;
import io.netty.util.HashedWheelTimer;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBookieEnsemblePlacementPolicy
implements EnsemblePlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(LocalBookieEnsemblePlacementPolicy.class);
    private BookieId bookieAddress;

    @Override
    public EnsemblePlacementPolicy initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer hashedWheelTimer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        ServerConfiguration serverConf = new ServerConfiguration();
        serverConf.addConfiguration((Configuration)conf);
        try {
            this.bookieAddress = BookieImpl.getBookieId(serverConf);
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to get bookie address", (Throwable)e);
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public void uninitalize() {
    }

    @Override
    public Set<BookieId> onClusterChanged(Set<BookieId> writableBookies, Set<BookieId> readOnlyBookies) {
        return Collections.emptySet();
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        throw new BKException.BKNotEnoughBookiesException();
    }

    @Override
    public void registerSlowBookie(BookieId bookieSocketAddress, long entryId) {
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return writeSet;
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return writeSet;
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        if (ensembleSize > 1) {
            throw new IllegalArgumentException("Local ensemble policy can only return 1 bookie");
        }
        return EnsemblePlacementPolicy.PlacementResult.of(Lists.newArrayList((Object[])new BookieId[]{this.bookieAddress}), EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT);
    }

    @Override
    public void updateBookieInfo(Map<BookieId, BookieInfoReader.BookieInfo> bookieToFreeSpaceMap) {
    }

    @Override
    public EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy(List<BookieId> ensembleList, int writeQuorumSize, int ackQuorumSize) {
        return EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT;
    }
}

