/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import com.twitter.common.objectsize.ObjectSizeCalculator;
import io.airlift.log.Logger;
import org.objenesis.ObjenesisStd;

public class ClassLayout {
    private static final Logger log = Logger.get(ClassLayout.class);
    private int size;
    private static final int DEFAULT_SIZE = 64;

    private ClassLayout(int size) {
        this.size = size;
    }

    public static ClassLayout parseClass(Class<?> clazz) {
        long size = 64L;
        try {
            size = ObjectSizeCalculator.getObjectSize((Object)new ObjenesisStd().newInstance(clazz));
        }
        catch (Throwable th) {
            log.info("Error estimating size of class %s", new Object[]{clazz, th});
        }
        return new ClassLayout(Math.toIntExact(size));
    }

    public int instanceSize() {
        return this.size;
    }
}

