/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.launcher;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.cli.CLIException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.cli.annotations.Description;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.cli.annotations.Hidden;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.cli.annotations.Option;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.launcher.Command;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.launcher.ExecutionContext;

public abstract class DefaultCommand
implements Command {
    private File cwd;
    protected List<String> systemProperties;
    protected ExecutionContext executionContext;
    protected PrintStream out;

    public File getCwd() {
        return this.cwd != null ? this.cwd : new File(".");
    }

    @Option(longName="cwd", argName="dir")
    @Description(value="Specifies the current working directory for this command, default set to the Java current directory")
    @Hidden
    public void setCwd(File cwd) {
        this.cwd = cwd;
    }

    @Option(longName="systemProperty", shortName="D", argName="key>=<value")
    @Description(value="Set a system property")
    @Hidden
    public void setSystemProps(List<String> props) {
        this.systemProperties = props;
    }

    @Override
    public void setUp(ExecutionContext ec) throws CLIException {
        this.executionContext = ec;
        this.out = this.executionContext.getPrintStream();
        this.applySystemProperties();
    }

    public PrintStream out() {
        return this.executionContext.getPrintStream();
    }

    @Override
    public void tearDown() throws CLIException {
    }

    protected void applySystemProperties() {
        if (this.systemProperties != null) {
            for (String prop : this.systemProperties) {
                int p = prop.indexOf(61);
                if (p <= 0) continue;
                String key = prop.substring(0, p);
                String val = prop.substring(p + 1);
                System.setProperty(key, val);
            }
        }
    }
}

