/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import java.util.Map;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SystemColumnHandle
implements ColumnHandle {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SystemColumnHandle.class).instanceSize();
    private final String columnName;

    @JsonCreator
    public SystemColumnHandle(@JsonProperty(value="columnName") String columnName) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemColumnHandle other = (SystemColumnHandle)obj;
        return this.columnName.equals(other.columnName);
    }

    public String toString() {
        return this.columnName;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.columnName);
    }

    public static Map<String, ColumnHandle> toSystemColumnHandles(ConnectorTableMetadata tableMetadata) {
        return (Map)tableMetadata.getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new SystemColumnHandle(column.getName())));
    }
}

