/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system.jdbc;

import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.connector.system.jdbc.FilterUtil;
import io.trino.connector.system.jdbc.JdbcTable;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.security.AccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class TableJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "tables");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.createUnboundedVarcharType()).column("table_schem", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_type", (Type)VarcharType.createUnboundedVarcharType()).column("remarks", (Type)VarcharType.createUnboundedVarcharType()).column("type_cat", (Type)VarcharType.createUnboundedVarcharType()).column("type_schem", (Type)VarcharType.createUnboundedVarcharType()).column("type_name", (Type)VarcharType.createUnboundedVarcharType()).column("self_referencing_col_name", (Type)VarcharType.createUnboundedVarcharType()).column("ref_generation", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public TableJdbcTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Optional<String> catalogFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 1);
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 2);
        Optional<String> typeFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 3);
        boolean includeTables = FilterUtil.emptyOrEquals(typeFilter, "TABLE");
        boolean includeViews = FilterUtil.emptyOrEquals(typeFilter, "VIEW");
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        if (!includeTables && !includeViews) {
            return table.build().cursor();
        }
        if (TableJdbcTable.isNonLowercase(schemaFilter) || TableJdbcTable.isNonLowercase(tableFilter)) {
            return table.build().cursor();
        }
        for (String catalog : MetadataListing.listCatalogs(session, this.metadata, this.accessControl, catalogFilter).keySet()) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            Set<SchemaTableName> views = MetadataListing.listViews(session, this.metadata, this.accessControl, prefix);
            for (SchemaTableName name : MetadataListing.listTables(session, this.metadata, this.accessControl, prefix)) {
                boolean isView = views.contains(name);
                if ((!includeTables || isView) && (!includeViews || !isView)) continue;
                table.addRow(TableJdbcTable.tableRow(catalog, name, isView ? "VIEW" : "TABLE"));
            }
        }
        return table.build().cursor();
    }

    private static boolean isNonLowercase(Optional<String> filter) {
        return filter.filter(value -> !value.equals(value.toLowerCase(Locale.ENGLISH))).isPresent();
    }

    private static Object[] tableRow(String catalog, SchemaTableName name, String type) {
        return new Object[]{catalog, name.getSchemaName(), name.getTableName(), type, null, null, null, null, null, null};
    }
}

