/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class FailureInjectionConfig {
    private Duration expirationPeriod = new Duration(10.0, TimeUnit.MINUTES);
    private Duration requestTimeout = new Duration(2.0, TimeUnit.MINUTES);

    @NotNull
    public Duration getExpirationPeriod() {
        return this.expirationPeriod;
    }

    @Config(value="failure-injection.expiration-period")
    @ConfigDescription(value="Period after which an injected failure is considered expired and will no longer be triggering a failure")
    public FailureInjectionConfig setExpirationPeriod(Duration expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
        return this;
    }

    @NotNull
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="failure-injection.request-timeout")
    @ConfigDescription(value="Period after which requests blocked to emulate a timeout are released")
    public FailureInjectionConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }
}

