/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.policy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.trino.execution.scheduler.StageExecution;
import io.trino.execution.scheduler.policy.ExecutionSchedule;
import io.trino.execution.scheduler.policy.StagesScheduleResult;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import oshi.annotation.concurrent.GuardedBy;

public class PhasedExecutionSchedule
implements ExecutionSchedule {
    private final DirectedGraph<PlanFragmentId, FragmentsEdge> fragmentDependency;
    private final DirectedGraph<PlanFragmentId, FragmentsEdge> fragmentTopology;
    private final Map<PlanFragmentId, StageExecution> stagesByFragmentId;
    private final Set<StageExecution> activeStages = new HashSet<StageExecution>();
    @GuardedBy(value="this")
    private SettableFuture<Void> rescheduleFuture = SettableFuture.create();

    public static PhasedExecutionSchedule forStages(Collection<StageExecution> stages) {
        PhasedExecutionSchedule schedule = new PhasedExecutionSchedule(stages);
        schedule.init(stages);
        return schedule;
    }

    private PhasedExecutionSchedule(Collection<StageExecution> stages) {
        this.fragmentDependency = new DefaultDirectedGraph((EdgeFactory)new FragmentsEdgeFactory());
        this.fragmentTopology = new DefaultDirectedGraph((EdgeFactory)new FragmentsEdgeFactory());
        this.stagesByFragmentId = (Map)stages.stream().collect(ImmutableMap.toImmutableMap(stage -> stage.getFragment().getId(), Function.identity()));
    }

    private void init(Collection<StageExecution> stages) {
        this.extractDependenciesAndReturnNonLazyFragments((Collection)stages.stream().map(StageExecution::getFragment).collect(ImmutableList.toImmutableList())).stream().map(this.stagesByFragmentId::get).forEach(this::selectForExecution);
        this.fragmentDependency.vertexSet().stream().filter(fragmentId -> this.fragmentDependency.inDegreeOf(fragmentId) == 0).map(this.stagesByFragmentId::get).forEach(this::selectForExecution);
    }

    @Override
    public StagesScheduleResult getStagesToSchedule() {
        Optional<ListenableFuture<Void>> rescheduleFuture = this.getRescheduleFuture();
        this.schedule();
        return new StagesScheduleResult(this.activeStages, rescheduleFuture);
    }

    @Override
    public boolean isFinished() {
        return this.fragmentDependency.vertexSet().isEmpty();
    }

    @VisibleForTesting
    synchronized Optional<ListenableFuture<Void>> getRescheduleFuture() {
        return Optional.of(this.rescheduleFuture);
    }

    @VisibleForTesting
    void schedule() {
        this.removeCompletedStages();
        this.unblockStagesWithFullOutputBuffer();
    }

    @VisibleForTesting
    DirectedGraph<PlanFragmentId, FragmentsEdge> getFragmentDependency() {
        return this.fragmentDependency;
    }

    @VisibleForTesting
    Set<StageExecution> getActiveStages() {
        return this.activeStages;
    }

    private void removeCompletedStages() {
        Set completedStages = (Set)this.activeStages.stream().filter(this::isStageCompleted).collect(ImmutableSet.toImmutableSet());
        completedStages.forEach(this::removeCompletedStage);
    }

    private void removeCompletedStage(StageExecution stage) {
        PlanFragmentId fragmentId = stage.getFragment().getId();
        this.fragmentDependency.outgoingEdgesOf((Object)fragmentId).stream().map(FragmentsEdge::getTarget).filter(dependentFragmentId -> this.fragmentDependency.inDegreeOf(dependentFragmentId) == 1).map(this.stagesByFragmentId::get).forEach(this::selectForExecution);
        this.fragmentDependency.removeVertex((Object)fragmentId);
        this.fragmentTopology.removeVertex((Object)fragmentId);
        this.activeStages.remove(stage);
    }

    private void unblockStagesWithFullOutputBuffer() {
        Set blockedFragments = (Set)this.activeStages.stream().filter(StageExecution::isAnyTaskBlocked).map(stage -> stage.getFragment().getId()).collect(ImmutableSet.toImmutableSet());
        blockedFragments.stream().flatMap(fragmentId -> this.fragmentTopology.outgoingEdgesOf(fragmentId).stream()).map(FragmentsEdge::getTarget).map(this.stagesByFragmentId::get).forEach(this::selectForExecution);
    }

    private void selectForExecution(StageExecution stage) {
        if (this.fragmentDependency.outDegreeOf((Object)stage.getFragment().getId()) > 0) {
            stage.addStateChangeListener(state -> {
                if (this.isStageCompleted(stage)) {
                    this.notifyReschedule();
                }
            });
        }
        this.activeStages.add(stage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReschedule() {
        SettableFuture<Void> rescheduleFuture;
        PhasedExecutionSchedule phasedExecutionSchedule = this;
        synchronized (phasedExecutionSchedule) {
            rescheduleFuture = this.rescheduleFuture;
            this.rescheduleFuture = SettableFuture.create();
        }
        rescheduleFuture.set(null);
    }

    private boolean isStageCompleted(StageExecution stage) {
        StageExecution.State state = stage.getState();
        return state == StageExecution.State.SCHEDULED || state == StageExecution.State.RUNNING || state == StageExecution.State.FLUSHING || state.isDone();
    }

    private Set<PlanFragmentId> extractDependenciesAndReturnNonLazyFragments(Collection<PlanFragment> fragments) {
        Visitor visitor = new Visitor(fragments);
        visitor.processAllFragments();
        List components = new StrongConnectivityInspector(this.fragmentDependency).stronglyConnectedSets();
        Verify.verify((components.size() == this.fragmentDependency.vertexSet().size() ? 1 : 0) != 0, (String)"circular dependency between stages", (Object[])new Object[0]);
        return visitor.getNonLazyFragments();
    }

    private static class FragmentsEdgeFactory
    implements EdgeFactory<PlanFragmentId, FragmentsEdge> {
        private FragmentsEdgeFactory() {
        }

        public FragmentsEdge createEdge(PlanFragmentId sourceVertex, PlanFragmentId targetVertex) {
            return new FragmentsEdge(sourceVertex, targetVertex);
        }
    }

    private class Visitor
    extends PlanVisitor<FragmentSubGraph, PlanFragmentId> {
        private final Map<PlanFragmentId, PlanFragment> fragments;
        private final ImmutableSet.Builder<PlanFragmentId> nonLazyFragments = ImmutableSet.builder();
        private final Map<PlanFragmentId, FragmentSubGraph> fragmentSubGraphs = new HashMap<PlanFragmentId, FragmentSubGraph>();

        public Visitor(Collection<PlanFragment> fragments) {
            this.fragments = (Map)Objects.requireNonNull(fragments, "fragments is null").stream().collect(ImmutableMap.toImmutableMap(PlanFragment::getId, Function.identity()));
        }

        public Set<PlanFragmentId> getNonLazyFragments() {
            return this.nonLazyFragments.build();
        }

        public void processAllFragments() {
            this.fragments.forEach((fragmentId, fragment) -> {
                PhasedExecutionSchedule.this.fragmentDependency.addVertex(fragmentId);
                PhasedExecutionSchedule.this.fragmentTopology.addVertex(fragmentId);
            });
            this.fragments.forEach((fragmentId, fragment) -> this.processFragment((PlanFragmentId)fragmentId));
        }

        public FragmentSubGraph processFragment(PlanFragmentId planFragmentId) {
            if (this.fragmentSubGraphs.containsKey(planFragmentId)) {
                return this.fragmentSubGraphs.get(planFragmentId);
            }
            FragmentSubGraph subGraph = this.processFragment(this.fragments.get(planFragmentId));
            Verify.verify((this.fragmentSubGraphs.put(planFragmentId, subGraph) == null ? 1 : 0) != 0, (String)"fragment %s was already processed", (Object)planFragmentId);
            return subGraph;
        }

        private FragmentSubGraph processFragment(PlanFragment fragment) {
            ImmutableSet lazyUpstreamFragments;
            FragmentSubGraph subGraph = fragment.getRoot().accept(this, fragment.getId());
            ImmutableSet upstreamFragments = ImmutableSet.builder().addAll(subGraph.getUpstreamFragments()).add((Object)fragment.getId()).build();
            if (subGraph.isCurrentFragmentLazy()) {
                lazyUpstreamFragments = ImmutableSet.builder().addAll(subGraph.getLazyUpstreamFragments()).add((Object)fragment.getId()).build();
            } else {
                lazyUpstreamFragments = subGraph.getLazyUpstreamFragments();
                this.nonLazyFragments.add((Object)fragment.getId());
            }
            return new FragmentSubGraph((Set<PlanFragmentId>)upstreamFragments, (Set<PlanFragmentId>)lazyUpstreamFragments, false);
        }

        @Override
        public FragmentSubGraph visitJoin(JoinNode node, PlanFragmentId currentFragmentId) {
            return this.processJoin(node.getDistributionType().orElseThrow() == JoinNode.DistributionType.REPLICATED, node.getLeft(), node.getRight(), currentFragmentId);
        }

        @Override
        public FragmentSubGraph visitSpatialJoin(SpatialJoinNode node, PlanFragmentId currentFragmentId) {
            return this.processJoin(node.getDistributionType() == SpatialJoinNode.DistributionType.REPLICATED, node.getLeft(), node.getRight(), currentFragmentId);
        }

        @Override
        public FragmentSubGraph visitSemiJoin(SemiJoinNode node, PlanFragmentId currentFragmentId) {
            return this.processJoin(node.getDistributionType().orElseThrow() == SemiJoinNode.DistributionType.REPLICATED, node.getSource(), node.getFilteringSource(), currentFragmentId);
        }

        @Override
        public FragmentSubGraph visitIndexJoin(IndexJoinNode node, PlanFragmentId currentFragmentId) {
            return this.processJoin(true, node.getProbeSource(), node.getIndexSource(), currentFragmentId);
        }

        private FragmentSubGraph processJoin(boolean replicated, PlanNode probe, PlanNode build, PlanFragmentId currentFragmentId) {
            boolean currentFragmentLazy;
            FragmentSubGraph probeSubGraph = probe.accept(this, currentFragmentId);
            FragmentSubGraph buildSubGraph = build.accept(this, currentFragmentId);
            this.addDependencyEdges(buildSubGraph.getUpstreamFragments(), probeSubGraph.getLazyUpstreamFragments());
            boolean bl = currentFragmentLazy = probeSubGraph.isCurrentFragmentLazy() && buildSubGraph.isCurrentFragmentLazy();
            if (replicated && currentFragmentLazy) {
                this.addDependencyEdges(buildSubGraph.getUpstreamFragments(), (Set<PlanFragmentId>)ImmutableSet.of((Object)currentFragmentId));
            } else {
                currentFragmentLazy = false;
            }
            return new FragmentSubGraph((Set<PlanFragmentId>)ImmutableSet.builder().addAll(probeSubGraph.getUpstreamFragments()).addAll(buildSubGraph.getUpstreamFragments()).build(), probeSubGraph.getLazyUpstreamFragments(), currentFragmentLazy);
        }

        @Override
        public FragmentSubGraph visitAggregation(AggregationNode node, PlanFragmentId currentFragmentId) {
            FragmentSubGraph subGraph = node.getSource().accept(this, currentFragmentId);
            if (node.getStep() != AggregationNode.Step.FINAL && node.getStep() != AggregationNode.Step.SINGLE) {
                return subGraph;
            }
            return new FragmentSubGraph(subGraph.getUpstreamFragments(), (Set<PlanFragmentId>)ImmutableSet.of(), false);
        }

        @Override
        public FragmentSubGraph visitRemoteSource(RemoteSourceNode node, PlanFragmentId currentFragmentId) {
            List subGraphs = (List)node.getSourceFragmentIds().stream().map(this::processFragment).collect(ImmutableList.toImmutableList());
            node.getSourceFragmentIds().forEach(sourceFragmentId -> PhasedExecutionSchedule.this.fragmentTopology.addEdge(sourceFragmentId, (Object)currentFragmentId));
            return new FragmentSubGraph((Set)subGraphs.stream().flatMap(source -> source.getUpstreamFragments().stream()).collect(ImmutableSet.toImmutableSet()), (Set)subGraphs.stream().flatMap(source -> source.getLazyUpstreamFragments().stream()).collect(ImmutableSet.toImmutableSet()), true);
        }

        @Override
        public FragmentSubGraph visitExchange(ExchangeNode node, PlanFragmentId currentFragmentId) {
            Preconditions.checkArgument((node.getScope() == ExchangeNode.Scope.LOCAL ? 1 : 0) != 0, (Object)"Only local exchanges are supported in the phased execution scheduler");
            return this.visitPlan((PlanNode)node, currentFragmentId);
        }

        @Override
        protected FragmentSubGraph visitPlan(PlanNode node, PlanFragmentId currentFragmentId) {
            List sourceSubGraphs = (List)node.getSources().stream().map(subPlanNode -> subPlanNode.accept(this, currentFragmentId)).collect(ImmutableList.toImmutableList());
            return new FragmentSubGraph((Set)sourceSubGraphs.stream().flatMap(source -> source.getUpstreamFragments().stream()).collect(ImmutableSet.toImmutableSet()), (Set)sourceSubGraphs.stream().flatMap(source -> source.getLazyUpstreamFragments().stream()).collect(ImmutableSet.toImmutableSet()), sourceSubGraphs.stream().allMatch(FragmentSubGraph::isCurrentFragmentLazy));
        }

        private void addDependencyEdges(Set<PlanFragmentId> sourceFragments, Set<PlanFragmentId> targetFragments) {
            for (PlanFragmentId targetFragment : targetFragments) {
                for (PlanFragmentId sourceFragment : sourceFragments) {
                    PhasedExecutionSchedule.this.fragmentDependency.addEdge((Object)sourceFragment, (Object)targetFragment);
                }
            }
        }
    }

    @VisibleForTesting
    static class FragmentsEdge {
        private final PlanFragmentId source;
        private final PlanFragmentId target;

        public FragmentsEdge(PlanFragmentId source, PlanFragmentId target) {
            this.source = Objects.requireNonNull(source, "source is null");
            this.target = Objects.requireNonNull(target, "target is null");
        }

        public PlanFragmentId getSource() {
            return this.source;
        }

        public PlanFragmentId getTarget() {
            return this.target;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FragmentsEdge that = (FragmentsEdge)o;
            return this.source.equals(that.source) && this.target.equals(that.target);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.target);
        }
    }

    private static class FragmentSubGraph {
        private final Set<PlanFragmentId> upstreamFragments;
        private final Set<PlanFragmentId> lazyUpstreamFragments;
        private final boolean currentFragmentLazy;

        public FragmentSubGraph(Set<PlanFragmentId> upstreamFragments, Set<PlanFragmentId> lazyUpstreamFragments, boolean currentFragmentLazy) {
            this.upstreamFragments = Objects.requireNonNull(upstreamFragments, "upstreamFragments is null");
            this.lazyUpstreamFragments = Objects.requireNonNull(lazyUpstreamFragments, "lazyUpstreamFragments is null");
            this.currentFragmentLazy = currentFragmentLazy;
        }

        public Set<PlanFragmentId> getUpstreamFragments() {
            return this.upstreamFragments;
        }

        public Set<PlanFragmentId> getLazyUpstreamFragments() {
            return this.lazyUpstreamFragments;
        }

        public boolean isCurrentFragmentLazy() {
            return this.currentFragmentLazy;
        }
    }
}

