/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.Signature;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BoundSignature {
    private final String name;
    private final Type returnType;
    private final List<Type> argumentTypes;

    @JsonCreator
    public BoundSignature(@JsonProperty(value="name") String name, @JsonProperty(value="returnType") Type returnType, @JsonProperty(value="argumentTypes") List<Type> argumentTypes) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getReturnType() {
        return this.returnType;
    }

    public int getArity() {
        return this.argumentTypes.size();
    }

    public Type getArgumentType(int index) {
        return this.argumentTypes.get(index);
    }

    @JsonProperty
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public Signature toSignature() {
        return Signature.builder().name(this.name).returnType(this.returnType.getTypeSignature()).argumentTypes((List)this.argumentTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundSignature that = (BoundSignature)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.returnType, this.argumentTypes);
    }

    public String toString() {
        return this.name + this.argumentTypes.stream().map(Object::toString).collect(Collectors.joining(", ", "(", "):")) + this.returnType;
    }
}

