/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.execution.Lifespan;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OperatorInfo;
import io.trino.operator.PageBuffer;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.WorkProcessorOperatorAdapter;
import io.trino.operator.WorkProcessorOperatorFactory;
import io.trino.spi.Page;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import java.util.Optional;

public class BasicWorkProcessorOperatorAdapter
implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator {
    private final PageBuffer pageBuffer = new PageBuffer();
    private final WorkProcessorOperator operator;

    public static OperatorFactory createAdapterOperatorFactory(BasicAdapterWorkProcessorOperatorFactory operatorFactory) {
        return WorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorFactory));
    }

    private BasicWorkProcessorOperatorAdapter(ProcessorContext processorContext, BasicAdapterWorkProcessorOperatorFactory operatorFactory) {
        this.operator = Objects.requireNonNull(operatorFactory, "operatorFactory is null").createAdapterOperator(processorContext, this.pageBuffer.pages());
    }

    @Override
    public void finish() {
        this.pageBuffer.finish();
    }

    @Override
    public boolean needsInput() {
        return this.pageBuffer.isEmpty() && !this.pageBuffer.isFinished();
    }

    @Override
    public void addInput(Page page) {
        this.pageBuffer.add(page);
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.operator.getOutputPages();
    }

    @Override
    public Optional<OperatorInfo> getOperatorInfo() {
        return this.operator.getOperatorInfo();
    }

    @Override
    public void close() throws Exception {
        this.operator.close();
    }

    private static class Factory
    implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory {
        private final BasicAdapterWorkProcessorOperatorFactory operatorFactory;

        Factory(BasicAdapterWorkProcessorOperatorFactory operatorFactory) {
            this.operatorFactory = Objects.requireNonNull(operatorFactory, "operatorFactory is null");
        }

        @Override
        public WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory duplicate() {
            return new Factory(this.operatorFactory.duplicate());
        }

        @Override
        public int getOperatorId() {
            return this.operatorFactory.getOperatorId();
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.operatorFactory.getPlanNodeId();
        }

        @Override
        public String getOperatorType() {
            return this.operatorFactory.getOperatorType();
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            return this.operatorFactory.create(processorContext, sourcePages);
        }

        @Override
        public WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator createAdapterOperator(ProcessorContext processorContext) {
            return new BasicWorkProcessorOperatorAdapter(processorContext, this.operatorFactory);
        }

        @Override
        public void lifespanFinished(Lifespan lifespan) {
            this.operatorFactory.lifespanFinished(lifespan);
        }

        @Override
        public void close() {
            this.operatorFactory.close();
        }
    }

    public static interface BasicAdapterWorkProcessorOperatorFactory
    extends WorkProcessorOperatorFactory {
        default public WorkProcessorOperator createAdapterOperator(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            return this.create(processorContext, sourcePages);
        }

        public BasicAdapterWorkProcessorOperatorFactory duplicate();
    }
}

