/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.trino.operator.PagesSpatialIndex;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PagesSpatialIndexFactory {
    private final List<Type> types;
    private final List<Type> outputTypes;
    @GuardedBy(value="this")
    private final List<SettableFuture<PagesSpatialIndex>> pagesSpatialIndexFutures = new ArrayList<SettableFuture<PagesSpatialIndex>>();
    @Nullable
    @GuardedBy(value="this")
    private Supplier<PagesSpatialIndex> pagesSpatialIndex;
    private final SettableFuture<Void> destroyed = SettableFuture.create();

    public PagesSpatialIndexFactory(List<Type> types, List<Type> outputTypes) {
        this.types = ImmutableList.copyOf(types);
        this.outputTypes = ImmutableList.copyOf(outputTypes);
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed.set(null);
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this;
        synchronized (pagesSpatialIndexFactory) {
            this.pagesSpatialIndex = null;
            this.pagesSpatialIndexFutures.clear();
        }
    }

    public synchronized ListenableFuture<PagesSpatialIndex> createPagesSpatialIndex() {
        Preconditions.checkState((!this.destroyed.isDone() ? 1 : 0) != 0, (Object)"already destroyed");
        if (this.pagesSpatialIndex != null) {
            return Futures.immediateFuture((Object)this.pagesSpatialIndex.get());
        }
        SettableFuture future = SettableFuture.create();
        this.pagesSpatialIndexFutures.add((SettableFuture<PagesSpatialIndex>)future);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> lendPagesSpatialIndex(Supplier<PagesSpatialIndex> pagesSpatialIndex) {
        ImmutableList settableFutures;
        Objects.requireNonNull(pagesSpatialIndex, "pagesSpatialIndex is null");
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this;
        synchronized (pagesSpatialIndexFactory) {
            if (this.destroyed.isDone()) {
                return this.destroyed;
            }
            Verify.verify((this.pagesSpatialIndex == null ? 1 : 0) != 0);
            this.pagesSpatialIndex = pagesSpatialIndex;
            settableFutures = ImmutableList.copyOf(this.pagesSpatialIndexFutures);
            this.pagesSpatialIndexFutures.clear();
        }
        for (SettableFuture settableFuture : settableFutures) {
            settableFuture.set((Object)pagesSpatialIndex.get());
        }
        return this.destroyed;
    }
}

