/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.ApproximateMostFrequentHistogram;
import io.trino.operator.aggregation.LongApproximateMostFrequentStateFactory;
import io.trino.operator.aggregation.LongApproximateMostFrequentStateSerializer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateMetadata;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.util.Failures;

@AggregationFunction(value="approx_most_frequent")
public final class BigintApproximateMostFrequent {
    private BigintApproximateMostFrequent() {
    }

    @InputFunction
    public static void input(@AggregationState State state, @SqlType(value="bigint") long buckets, @SqlType(value="bigint") long value, @SqlType(value="bigint") long capacity) {
        ApproximateMostFrequentHistogram<Long> histogram = state.get();
        if (histogram == null) {
            Failures.checkCondition(buckets >= 2L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "approx_most_frequent bucket count must be greater than one", new Object[0]);
            histogram = new ApproximateMostFrequentHistogram<Long>(Math.toIntExact(buckets), Math.toIntExact(capacity), LongApproximateMostFrequentStateSerializer::serializeBucket, LongApproximateMostFrequentStateSerializer::deserializeBucket);
            state.set(histogram);
        }
        histogram.add(value);
    }

    @CombineFunction
    public static void combine(@AggregationState State state, @AggregationState State otherState) {
        ApproximateMostFrequentHistogram<Long> otherHistogram = otherState.get();
        ApproximateMostFrequentHistogram<Long> histogram = state.get();
        if (histogram == null) {
            state.set(otherHistogram);
        } else {
            histogram.merge(otherHistogram);
        }
    }

    @OutputFunction(value="map(bigint,bigint)")
    public static void output(@AggregationState State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            BlockBuilder entryBuilder = out.beginBlockEntry();
            state.get().forEachBucket((key, value) -> {
                BigintType.BIGINT.writeLong(entryBuilder, key.longValue());
                BigintType.BIGINT.writeLong(entryBuilder, value);
            });
            out.closeEntry();
        }
    }

    @AccumulatorStateMetadata(stateSerializerClass=LongApproximateMostFrequentStateSerializer.class, stateFactoryClass=LongApproximateMostFrequentStateFactory.class)
    public static interface State
    extends AccumulatorState {
        public ApproximateMostFrequentHistogram<Long> get();

        public void set(ApproximateMostFrequentHistogram<Long> var1);
    }
}

