/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.CovarianceState;

public interface CorrelationState
extends CovarianceState {
    public double getM2X();

    public void setM2X(double var1);

    public double getM2Y();

    public void setM2Y(double var1);

    @Override
    default public void update(double x, double y) {
        double oldMeanX = this.getMeanX();
        double oldMeanY = this.getMeanY();
        CovarianceState.super.update(x, y);
        this.setM2X(this.getM2X() + (x - oldMeanX) * (x - this.getMeanX()));
        this.setM2Y(this.getM2Y() + (y - oldMeanY) * (y - this.getMeanY()));
    }

    default public void merge(CorrelationState otherState) {
        if (otherState.getCount() == 0L) {
            return;
        }
        long na = this.getCount();
        long nb = otherState.getCount();
        this.setM2X(this.getM2X() + otherState.getM2X() + (double)(na * nb) * Math.pow(this.getMeanX() - otherState.getMeanX(), 2.0) / (double)(na + nb));
        this.setM2Y(this.getM2Y() + otherState.getM2Y() + (double)(na * nb) * Math.pow(this.getMeanY() - otherState.getMeanY(), 2.0) / (double)(na + nb));
        CovarianceState.super.merge(otherState);
    }

    default public double getCorrelation() {
        double covariance = this.getC2();
        double stdevX = Math.sqrt(this.getM2X());
        double stdevY = Math.sqrt(this.getM2Y());
        return covariance / stdevX / stdevY;
    }
}

