/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.GenericLongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import java.util.Objects;

public class GenericLongStateSerializer
implements AccumulatorStateSerializer<GenericLongState> {
    private final Type serializedType;

    public GenericLongStateSerializer(Type serializedType) {
        this.serializedType = Objects.requireNonNull(serializedType, "serializedType is null");
    }

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(GenericLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            this.serializedType.writeLong(out, state.getValue());
        }
    }

    public void deserialize(Block block, int index, GenericLongState state) {
        state.setNull(false);
        state.setValue(this.serializedType.getLong(block, index));
    }
}

