/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.XxHash64;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.execution.Lifespan;
import io.trino.operator.BucketPartitionFunction;
import io.trino.operator.HashGenerator;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.operator.PartitionFunction;
import io.trino.operator.PipelineExecutionStrategy;
import io.trino.operator.PrecomputedHashGenerator;
import io.trino.operator.exchange.BroadcastExchanger;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchangeSink;
import io.trino.operator.exchange.LocalExchangeSource;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.operator.exchange.LocalPartitionGenerator;
import io.trino.operator.exchange.PartitioningExchanger;
import io.trino.operator.exchange.PassthroughExchanger;
import io.trino.operator.exchange.RandomExchanger;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.type.Type;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.type.BlockTypeOperators;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalExchange {
    private final Supplier<LocalExchanger> exchangerSupplier;
    private final List<LocalExchangeSource> sources;
    private final LocalExchangeMemoryManager memoryManager;
    @GuardedBy(value="this")
    private boolean allSourcesFinished;
    @GuardedBy(value="this")
    private boolean noMoreSinkFactories;
    @GuardedBy(value="this")
    private final List<LocalExchangeSinkFactory> allSinkFactories;
    @GuardedBy(value="this")
    private final Set<LocalExchangeSinkFactory> openSinkFactories = new HashSet<LocalExchangeSinkFactory>();
    @GuardedBy(value="this")
    private final Set<LocalExchangeSink> sinks = new HashSet<LocalExchangeSink>();
    @GuardedBy(value="this")
    private int nextSourceIndex;

    public LocalExchange(NodePartitioningManager nodePartitioningManager, Session session, int sinkFactoryCount, int bufferCount, PartitioningHandle partitioning, List<Integer> partitionChannels, List<Type> partitionChannelTypes, Optional<Integer> partitionHashChannel, DataSize maxBufferedBytes, BlockTypeOperators blockTypeOperators) {
        this.allSinkFactories = (List)Stream.generate(() -> new LocalExchangeSinkFactory(this)).limit(sinkFactoryCount).collect(ImmutableList.toImmutableList());
        this.openSinkFactories.addAll(this.allSinkFactories);
        this.noMoreSinkFactories();
        ImmutableList.Builder sources = ImmutableList.builder();
        for (int i = 0; i < bufferCount; ++i) {
            sources.add((Object)new LocalExchangeSource(source -> this.checkAllSourcesFinished()));
        }
        this.sources = sources.build();
        List buffers = (List)this.sources.stream().map(buffer -> buffer::addPage).collect(ImmutableList.toImmutableList());
        this.memoryManager = new LocalExchangeMemoryManager(maxBufferedBytes.toBytes());
        if (partitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new BroadcastExchanger(buffers, this.memoryManager);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new BroadcastExchanger(buffers, this.memoryManager);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new RandomExchanger(buffers, this.memoryManager);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION)) {
            Iterator<LocalExchangeSource> sourceIterator = this.sources.iterator();
            this.exchangerSupplier = () -> {
                Preconditions.checkState((boolean)sourceIterator.hasNext(), (Object)"no more sources");
                return new PassthroughExchanger((LocalExchangeSource)sourceIterator.next(), maxBufferedBytes.toBytes() / (long)bufferCount, this.memoryManager::updateMemoryUsage);
            };
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioning.getConnectorId().isPresent()) {
            this.exchangerSupplier = () -> {
                Function<Page, Page> partitionPagePreparer;
                PartitionFunction partitionFunction = LocalExchange.createPartitionFunction(nodePartitioningManager, session, blockTypeOperators, partitioning, bufferCount, partitionChannels, partitionChannelTypes, partitionHashChannel);
                if (LocalExchange.isSystemPartitioning(partitioning)) {
                    partitionPagePreparer = Function.identity();
                } else {
                    int[] partitionChannelsArray = Ints.toArray((Collection)partitionChannels);
                    partitionPagePreparer = page -> page.getColumns(partitionChannelsArray);
                }
                return new PartitioningExchanger(buffers, this.memoryManager, partitionPagePreparer, partitionFunction);
            };
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
    }

    public int getBufferCount() {
        return this.sources.size();
    }

    public long getBufferedBytes() {
        return this.memoryManager.getBufferedBytes();
    }

    public synchronized LocalExchangeSinkFactory createSinkFactory() {
        Preconditions.checkState((!this.noMoreSinkFactories ? 1 : 0) != 0, (Object)"No more sink factories already set");
        LocalExchangeSinkFactory newFactory = new LocalExchangeSinkFactory(this);
        this.openSinkFactories.add(newFactory);
        return newFactory;
    }

    public synchronized LocalExchangeSinkFactory getSinkFactory(LocalExchangeSinkFactoryId id) {
        return this.allSinkFactories.get(id.id);
    }

    public synchronized LocalExchangeSource getNextSource() {
        Preconditions.checkState((this.nextSourceIndex < this.sources.size() ? 1 : 0) != 0, (Object)"All operators already created");
        LocalExchangeSource result = this.sources.get(this.nextSourceIndex);
        ++this.nextSourceIndex;
        return result;
    }

    @VisibleForTesting
    LocalExchangeSource getSource(int partitionIndex) {
        return this.sources.get(partitionIndex);
    }

    private static PartitionFunction createPartitionFunction(NodePartitioningManager nodePartitioningManager, Session session, BlockTypeOperators blockTypeOperators, PartitioningHandle partitioning, int partitionCount, List<Integer> partitionChannels, List<Type> partitionChannelTypes, Optional<Integer> partitionHashChannel) {
        Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
        if (LocalExchange.isSystemPartitioning(partitioning)) {
            HashGenerator hashGenerator = partitionHashChannel.isPresent() ? new PrecomputedHashGenerator(partitionHashChannel.get()) : new InterpretedHashGenerator(partitionChannelTypes, Ints.toArray(partitionChannels), blockTypeOperators);
            return new LocalPartitionGenerator(hashGenerator, partitionCount);
        }
        ConnectorBucketNodeMap connectorBucketNodeMap = nodePartitioningManager.getConnectorBucketNodeMap(session, partitioning);
        int bucketCount = connectorBucketNodeMap.getBucketCount();
        int[] bucketToPartition = new int[bucketCount];
        for (int bucket = 0; bucket < bucketCount; ++bucket) {
            int hashedBucket = (int)XxHash64.hash((long)Long.reverse(bucket));
            bucketToPartition[bucket] = hashedBucket & partitionCount - 1;
        }
        return new BucketPartitionFunction(nodePartitioningManager.getBucketFunction(session, partitioning, partitionChannelTypes, bucketCount), bucketToPartition);
    }

    private static boolean isSystemPartitioning(PartitioningHandle partitioning) {
        return partitioning.getConnectorHandle() instanceof SystemPartitioningHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSourcesFinished() {
        ImmutableList openSinks;
        LocalExchange.checkNotHoldsLock(this);
        if (!this.sources.stream().allMatch(LocalExchangeSource::isFinished)) {
            return;
        }
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.allSourcesFinished = true;
            openSinks = ImmutableList.copyOf(this.sinks);
            this.sinks.clear();
        }
        openSinks.forEach(LocalExchangeSink::finish);
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalExchangeSink createSink(LocalExchangeSinkFactory factory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            Preconditions.checkState((boolean)this.openSinkFactories.contains(factory), (Object)"Factory is already closed");
            if (this.allSourcesFinished) {
                return LocalExchangeSink.finishedLocalExchangeSink();
            }
            LocalExchanger exchanger = this.exchangerSupplier.get();
            LocalExchangeSink sink = new LocalExchangeSink(exchanger, this::sinkFinished);
            this.sinks.add(sink);
            return sink;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFinished(LocalExchangeSink sink) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.sinks.remove(sink);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noMoreSinkFactories() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.noMoreSinkFactories = true;
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFactoryClosed(LocalExchangeSinkFactory sinkFactory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.openSinkFactories.remove(sinkFactory);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSinksComplete() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            if (!(this.noMoreSinkFactories && this.openSinkFactories.isEmpty() && this.sinks.isEmpty())) {
                return;
            }
        }
        this.sources.forEach(LocalExchangeSource::finish);
    }

    private static void checkNotHoldsLock(Object lock) {
        Preconditions.checkState((!Thread.holdsLock(lock) ? 1 : 0) != 0, (Object)"Cannot execute this method while holding a lock");
    }

    private static int computeBufferCount(PartitioningHandle partitioning, int defaultConcurrency, List<Integer> partitionChannels) {
        int bufferCount;
        if (partitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION)) {
            bufferCount = 1;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Gather exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Broadcast exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Arbitrary exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Passthrough exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioning.getConnectorId().isPresent()) {
            bufferCount = defaultConcurrency;
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
        return bufferCount;
    }

    @ThreadSafe
    public static class LocalExchangeSinkFactory
    implements Closeable {
        private final LocalExchange exchange;

        private LocalExchangeSinkFactory(LocalExchange exchange) {
            this.exchange = Objects.requireNonNull(exchange, "exchange is null");
        }

        public LocalExchangeSink createSink() {
            return this.exchange.createSink(this);
        }

        public LocalExchangeSinkFactory duplicate() {
            return this.exchange.createSinkFactory();
        }

        @Override
        public void close() {
            this.exchange.sinkFactoryClosed(this);
        }

        public void noMoreSinkFactories() {
            this.exchange.noMoreSinkFactories();
        }
    }

    public static class LocalExchangeSinkFactoryId {
        private final int id;

        public LocalExchangeSinkFactoryId(int id) {
            this.id = id;
        }
    }

    @ThreadSafe
    public static class LocalExchangeFactory {
        private final NodePartitioningManager nodePartitioningManager;
        private final Session session;
        private final PartitioningHandle partitioning;
        private final List<Integer> partitionChannels;
        private final List<Type> partitionChannelTypes;
        private final Optional<Integer> partitionHashChannel;
        private final PipelineExecutionStrategy exchangeSourcePipelineExecutionStrategy;
        private final DataSize maxBufferedBytes;
        private final BlockTypeOperators blockTypeOperators;
        private final int bufferCount;
        @GuardedBy(value="this")
        private boolean noMoreSinkFactories;
        @GuardedBy(value="this")
        private int numSinkFactories;
        @GuardedBy(value="this")
        private final Map<Lifespan, LocalExchange> localExchangeMap = new HashMap<Lifespan, LocalExchange>();
        @GuardedBy(value="this")
        private final List<LocalExchangeSinkFactoryId> closedSinkFactories = new ArrayList<LocalExchangeSinkFactoryId>();

        public LocalExchangeFactory(NodePartitioningManager nodePartitioningManager, Session session, PartitioningHandle partitioning, int defaultConcurrency, List<Type> types, List<Integer> partitionChannels, Optional<Integer> partitionHashChannel, PipelineExecutionStrategy exchangeSourcePipelineExecutionStrategy, DataSize maxBufferedBytes, BlockTypeOperators blockTypeOperators) {
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            Objects.requireNonNull(types, "types is null");
            this.partitionChannelTypes = (List)partitionChannels.stream().map(types::get).collect(ImmutableList.toImmutableList());
            this.partitionHashChannel = Objects.requireNonNull(partitionHashChannel, "partitionHashChannel is null");
            this.exchangeSourcePipelineExecutionStrategy = Objects.requireNonNull(exchangeSourcePipelineExecutionStrategy, "exchangeSourcePipelineExecutionStrategy is null");
            this.maxBufferedBytes = Objects.requireNonNull(maxBufferedBytes, "maxBufferedBytes is null");
            this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
            this.bufferCount = LocalExchange.computeBufferCount(partitioning, defaultConcurrency, partitionChannels);
        }

        public synchronized LocalExchangeSinkFactoryId newSinkFactoryId() {
            Preconditions.checkState((!this.noMoreSinkFactories ? 1 : 0) != 0);
            LocalExchangeSinkFactoryId result = new LocalExchangeSinkFactoryId(this.numSinkFactories);
            ++this.numSinkFactories;
            return result;
        }

        public synchronized void noMoreSinkFactories() {
            this.noMoreSinkFactories = true;
        }

        public int getBufferCount() {
            return this.bufferCount;
        }

        public synchronized LocalExchange getLocalExchange(Lifespan lifespan) {
            if (this.exchangeSourcePipelineExecutionStrategy == PipelineExecutionStrategy.UNGROUPED_EXECUTION) {
                Preconditions.checkArgument((boolean)lifespan.isTaskWide(), (Object)"LocalExchangeFactory is declared as UNGROUPED_EXECUTION. Driver-group exchange cannot be created.");
            } else {
                Preconditions.checkArgument((!lifespan.isTaskWide() ? 1 : 0) != 0, (Object)"LocalExchangeFactory is declared as GROUPED_EXECUTION. Task-wide exchange cannot be created.");
            }
            return this.localExchangeMap.computeIfAbsent(lifespan, ignored -> {
                Preconditions.checkState((boolean)this.noMoreSinkFactories);
                LocalExchange localExchange = new LocalExchange(this.nodePartitioningManager, this.session, this.numSinkFactories, this.bufferCount, this.partitioning, this.partitionChannels, this.partitionChannelTypes, this.partitionHashChannel, this.maxBufferedBytes, this.blockTypeOperators);
                for (LocalExchangeSinkFactoryId closedSinkFactoryId : this.closedSinkFactories) {
                    localExchange.getSinkFactory(closedSinkFactoryId).close();
                }
                return localExchange;
            });
        }

        public synchronized void closeSinks(LocalExchangeSinkFactoryId sinkFactoryId) {
            this.closedSinkFactories.add(sinkFactoryId);
            for (LocalExchange localExchange : this.localExchangeMap.values()) {
                localExchange.getSinkFactory(sinkFactoryId).close();
            }
        }
    }
}

