/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.base.Preconditions;
import io.trino.operator.index.IndexLoader;
import io.trino.operator.index.IndexedData;
import io.trino.operator.join.LookupSource;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IndexLookupSource
implements LookupSource {
    private final IndexLoader indexLoader;
    private IndexedData indexedData;

    public IndexLookupSource(IndexLoader indexLoader) {
        this.indexLoader = Objects.requireNonNull(indexLoader, "indexLoader is null");
        this.indexedData = indexLoader.getIndexSnapshot();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public long getJoinPositionCount() {
        return 0L;
    }

    @Override
    public long getInMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public long joinPositionWithinPartition(long joinPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        return this.getJoinPosition(position, hashChannelsPage, allChannelsPage);
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        long joinPosition = this.indexedData.getJoinPosition(position, hashChannelsPage);
        if (joinPosition == -2L) {
            this.indexedData.close();
            this.indexedData = this.indexLoader.getIndexedDataForKeys(position, hashChannelsPage);
            joinPosition = this.indexedData.getJoinPosition(position, hashChannelsPage);
            Preconditions.checkState((joinPosition != -2L ? 1 : 0) != 0);
        }
        return joinPosition;
    }

    @Override
    public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        long nextPosition = this.indexedData.getNextJoinPosition(currentJoinPosition);
        Preconditions.checkState((nextPosition != -2L ? 1 : 0) != 0);
        return nextPosition;
    }

    @Override
    public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        return true;
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.indexedData.appendTo(position, pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
        this.indexedData.close();
    }
}

