/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.block.Block;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import java.lang.invoke.MethodHandle;

@Description(value="Determines whether an array contains a sequence, with the values in the exact order")
@ScalarFunction(value="contains_sequence")
public final class ArrayContainsSequence {
    private ArrayContainsSequence() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean containsSequence(@OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle distinctFrom, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="array(T)") Block value) throws Throwable {
        int arrayLimit = arrayBlock.getPositionCount() - value.getPositionCount();
        for (int arrayPosition = 0; arrayPosition <= arrayLimit; ++arrayPosition) {
            if (!ArrayContainsSequence.containsSequenceAt(distinctFrom, arrayBlock, arrayPosition, value)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSequenceAt(MethodHandle distinctFrom, Block arrayBlock, int arrayPosition, Block value) throws Throwable {
        for (int valuePosition = 0; valuePosition < value.getPositionCount(); ++valuePosition) {
            if (!distinctFrom.invokeExact(arrayBlock, arrayPosition + valuePosition, value, valuePosition)) continue;
            return false;
        }
        return true;
    }
}

