/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import io.trino.util.DateTimeZoneIndex;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToTimestampWithTimeZoneCast {
    private TimestampToTimestampWithTimeZoneCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static long shortToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision)") long timestamp) {
        long epochMillis = DateTimes.scaleEpochMicrosToMillis(DateTimes.round(timestamp, 3));
        epochMillis = DateTimes.round(epochMillis, (int)(3L - targetPrecision));
        return TimestampToTimestampWithTimeZoneCast.toShort(session, epochMillis);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision)") LongTimestamp timestamp) {
        long epochMillis = DateTimes.scaleEpochMicrosToMillis(DateTimes.round(timestamp.getEpochMicros(), (int)(6L - targetPrecision)));
        return TimestampToTimestampWithTimeZoneCast.toShort(session, epochMillis);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static LongTimestampWithTimeZone shortToLong(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision)") long epochMicros) {
        if (sourcePrecision > targetPrecision) {
            epochMicros = DateTimes.round(epochMicros, (int)(6L - targetPrecision));
        }
        return TimestampToTimestampWithTimeZoneCast.toLong(session, epochMicros, 0);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static LongTimestampWithTimeZone longToLong(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision)") LongTimestamp timestamp) {
        if (sourcePrecision <= targetPrecision) {
            return TimestampToTimestampWithTimeZoneCast.toLong(session, timestamp.getEpochMicros(), timestamp.getPicosOfMicro());
        }
        long epochMicros = timestamp.getEpochMicros();
        int picosOfMicro = timestamp.getPicosOfMicro();
        if (targetPrecision < 6L) {
            epochMicros = DateTimes.round(epochMicros, (int)(6L - targetPrecision));
            picosOfMicro = 0;
        } else if (targetPrecision == 6L) {
            if (DateTimes.roundToNearest(picosOfMicro, 1000000L) == 1000000L) {
                ++epochMicros;
            }
            picosOfMicro = 0;
        } else {
            picosOfMicro = (int)DateTimes.round(picosOfMicro, (int)(12L - targetPrecision));
        }
        return TimestampToTimestampWithTimeZoneCast.toLong(session, epochMicros, picosOfMicro);
    }

    private static long toShort(ConnectorSession session, long epochMillis) {
        epochMillis = DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).getZone().convertLocalToUTC(epochMillis, false);
        try {
            return DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)session.getTimeZoneKey());
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Out of range for timestamp with time zone: " + epochMillis, (Throwable)e);
        }
    }

    private static LongTimestampWithTimeZone toLong(ConnectorSession session, long epochMicros, int picoOfMicroFraction) {
        long epochMillis = DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).getZone().convertLocalToUTC(DateTimes.scaleEpochMicrosToMillis(epochMicros), false);
        int picoOfMilliFraction = DateTimes.getMicrosOfMilli(epochMicros) * 1000000 + picoOfMicroFraction;
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picoOfMilliFraction, (TimeZoneKey)session.getTimeZoneKey());
    }
}

