/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.type.DateTimes;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

@ScalarFunction(value="$current_time", hidden=true)
public final class CurrentTime {
    private CurrentTime() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time(p) with time zone")
    public static long shortTime(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlNullable @SqlType(value="time(p) with time zone") Long dummy) {
        Instant start = session.getStart();
        ZoneId zoneId = session.getTimeZoneKey().getZoneId();
        long nanos = ZonedDateTime.ofInstant(start, zoneId).toLocalTime().toNanoOfDay();
        int offsetSeconds = zoneId.getRules().getOffset(start).getTotalSeconds();
        nanos = DateTimes.round(nanos, (int)(9L - precision)) % 86400000000000L;
        return DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)(offsetSeconds / 60));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time(p) with time zone")
    public static LongTimeWithTimeZone longTime(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlNullable @SqlType(value="time(p) with time zone") LongTimeWithTimeZone dummy) {
        Instant start = session.getStart();
        ZoneId zoneId = session.getTimeZoneKey().getZoneId();
        long nanos = ZonedDateTime.ofInstant(start, zoneId).toLocalTime().toNanoOfDay();
        int offsetSeconds = zoneId.getRules().getOffset(start).getTotalSeconds();
        long picos = Math.floorMod(DateTimes.round(nanos * 1000L, (int)(12L - precision)), 86400000000000000L);
        return new LongTimeWithTimeZone(picos, offsetSeconds / 60);
    }
}

