/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.trino.operator.unnest.Unnester;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.Objects;

class ArrayOfRowsUnnester
extends Unnester {
    private ColumnarArray columnarArray;
    private ColumnarRow columnarRow;
    private final int fieldCount;
    private int nullRowsEncountered;

    public ArrayOfRowsUnnester(RowType elementType) {
        super((Type[])Iterables.toArray((Iterable)Objects.requireNonNull(elementType, "elementType is null").getTypeParameters(), Type.class));
        this.fieldCount = elementType.getTypeParameters().size();
        this.nullRowsEncountered = 0;
    }

    @Override
    public int getChannelCount() {
        return this.fieldCount;
    }

    @Override
    int getInputEntryCount() {
        if (this.columnarArray == null) {
            return 0;
        }
        return this.columnarArray.getPositionCount();
    }

    @Override
    protected void resetColumnarStructure(Block block) {
        this.columnarArray = ColumnarArray.toColumnarArray((Block)block);
        this.columnarRow = ColumnarRow.toColumnarRow((Block)this.columnarArray.getElementsBlock());
        this.nullRowsEncountered = 0;
    }

    @Override
    public void processCurrentPosition(int requireCount) {
        int rowBlockIndex = this.columnarArray.getOffset(this.getCurrentPosition());
        for (int i = 0; i < this.getCurrentUnnestedLength(); ++i) {
            int field;
            if (this.columnarRow.isNull(rowBlockIndex + i)) {
                for (field = 0; field < this.fieldCount; ++field) {
                    this.getBlockBuilder(field).appendNull();
                }
                ++this.nullRowsEncountered;
                continue;
            }
            for (field = 0; field < this.fieldCount; ++field) {
                this.getBlockBuilder(field).appendElement(rowBlockIndex + i - this.nullRowsEncountered);
            }
        }
        this.appendNulls(requireCount - this.getCurrentUnnestedLength());
    }

    @Override
    public void appendNulls(int count) {
        for (int i = 0; i < count; ++i) {
            for (int field = 0; field < this.fieldCount; ++field) {
                this.getBlockBuilder(field).appendNull();
            }
        }
    }

    @Override
    protected Block getElementsBlock(int channel) {
        Preconditions.checkState((channel >= 0 && channel < this.fieldCount ? 1 : 0) != 0, (Object)"Invalid channel number");
        return this.columnarRow.getField(channel);
    }

    @Override
    protected int getElementsLength(int index) {
        return this.columnarArray.getLength(index);
    }
}

