/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.window.InternalWindowIndex;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MappedWindowIndex
implements InternalWindowIndex {
    private final int[] channelMap;
    private InternalWindowIndex delegate;

    public MappedWindowIndex(List<Integer> argumentChannels) {
        this.channelMap = Ints.toArray((Collection)Objects.requireNonNull(argumentChannels, "argumentChannels is null"));
    }

    public void setDelegate(InternalWindowIndex delegate) {
        this.delegate = delegate;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isNull(int channel, int position) {
        return this.delegate.isNull(this.toDelegateChannel(channel), position);
    }

    public boolean getBoolean(int channel, int position) {
        return this.delegate.getBoolean(this.toDelegateChannel(channel), position);
    }

    public long getLong(int channel, int position) {
        return this.delegate.getLong(this.toDelegateChannel(channel), position);
    }

    public double getDouble(int channel, int position) {
        return this.delegate.getDouble(this.toDelegateChannel(channel), position);
    }

    public Slice getSlice(int channel, int position) {
        return this.delegate.getSlice(this.toDelegateChannel(channel), position);
    }

    public Block getSingleValueBlock(int channel, int position) {
        return this.delegate.getSingleValueBlock(this.toDelegateChannel(channel), position);
    }

    public Object getObject(int channel, int position) {
        return this.delegate.getObject(this.toDelegateChannel(channel), position);
    }

    public void appendTo(int channel, int position, BlockBuilder output) {
        this.delegate.appendTo(this.toDelegateChannel(channel), position, output);
    }

    @Override
    @UsedByGeneratedCode
    public Block getRawBlock(int channel, int position) {
        return this.delegate.getRawBlock(this.toDelegateChannel(channel), position);
    }

    @Override
    @UsedByGeneratedCode
    public int getRawBlockPosition(int position) {
        return this.delegate.getRawBlockPosition(position);
    }

    private int toDelegateChannel(int channel) {
        return this.channelMap[channel];
    }
}

