/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.airlift.jaxrs.AsyncResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.trino.dispatcher.DispatchExecutor;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.OAuth2TokenExchange;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/oauth2/token/")
public class OAuth2TokenExchangeResource {
    static final String TOKEN_ENDPOINT = "/oauth2/token/";
    private static final JsonCodec<Map<String, Object>> MAP_CODEC = new JsonCodecFactory().mapJsonCodec(String.class, Object.class);
    private final OAuth2TokenExchange tokenExchange;
    private final OAuth2Service service;
    private final ListeningExecutorService responseExecutor;

    @Inject
    public OAuth2TokenExchangeResource(OAuth2TokenExchange tokenExchange, OAuth2Service service, DispatchExecutor executor) {
        this.tokenExchange = Objects.requireNonNull(tokenExchange, "tokenExchange is null");
        this.service = Objects.requireNonNull(service, "service is null");
        this.responseExecutor = Objects.requireNonNull(executor, "executor is null").getExecutor();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @Path(value="initiate/{authIdHash}")
    @GET
    @Produces(value={"application/json"})
    public Response initiateTokenExchange(@PathParam(value="authIdHash") String authIdHash, @Context UriInfo uriInfo) {
        return this.service.startOAuth2Challenge(uriInfo, authIdHash);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @Path(value="{authId}")
    @GET
    @Produces(value={"application/json"})
    public void getAuthenticationToken(@PathParam(value="authId") UUID authId, @Suspended AsyncResponse asyncResponse, @Context HttpServletRequest request) {
        if (authId == null) {
            throw new BadRequestException();
        }
        ListenableFuture<OAuth2TokenExchange.TokenPoll> tokenFuture = this.tokenExchange.getTokenPoll(authId);
        ListenableFuture responseFuture = Futures.transform(tokenFuture, OAuth2TokenExchangeResource::toResponse, (Executor)this.responseExecutor);
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)responseFuture, (Executor)this.responseExecutor).withTimeout(OAuth2TokenExchange.MAX_POLL_TIME, OAuth2TokenExchangeResource.pendingResponse(request));
    }

    private static Response toResponse(OAuth2TokenExchange.TokenPoll poll) {
        if (poll.getError().isPresent()) {
            return Response.ok((Object)OAuth2TokenExchangeResource.jsonMap("error", poll.getError().get()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        if (poll.getToken().isPresent()) {
            return Response.ok((Object)OAuth2TokenExchangeResource.jsonMap("token", poll.getToken().get()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        throw new VerifyException("invalid TokenPoll state");
    }

    private static Response pendingResponse(HttpServletRequest request) {
        return Response.ok((Object)OAuth2TokenExchangeResource.jsonMap("nextUri", request.getRequestURL()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @DELETE
    @Path(value="{authId}")
    public void deleteAuthenticationToken(@PathParam(value="authId") UUID authId) {
        if (authId == null) {
            throw new BadRequestException();
        }
        this.tokenExchange.dropToken(authId);
    }

    public static String getTokenUri(UUID authId) {
        return TOKEN_ENDPOINT + authId;
    }

    public static String getInitiateUri(UUID authId) {
        return "/oauth2/token/initiate/" + OAuth2TokenExchange.hashAuthId(authId);
    }

    private static String jsonMap(String key, Object value) {
        return MAP_CODEC.toJson((Object)ImmutableMap.of((Object)key, (Object)value));
    }
}

