/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.analyzer.OutputColumn;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Output {
    private final String catalogName;
    private final String schema;
    private final String table;
    private final Optional<List<OutputColumn>> columns;

    @JsonCreator
    public Output(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="columns") Optional<List<OutputColumn>> columns) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = Objects.requireNonNull(columns, "columns is null").map(ImmutableList::copyOf);
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public Optional<List<OutputColumn>> getColumns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Output output = (Output)o;
        return Objects.equals(this.catalogName, output.catalogName) && Objects.equals(this.schema, output.schema) && Objects.equals(this.table, output.table) && Objects.equals(this.columns, output.columns);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schema, this.table, this.columns);
    }
}

