/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PruneExchangeColumns
extends ProjectOffPushDownRule<ExchangeNode> {
    public PruneExchangeColumns() {
        super(Patterns.exchange());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, ExchangeNode exchangeNode, Set<Symbol> referencedOutputs) {
        int i;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(referencedOutputs);
        builder.addAll(exchangeNode.getPartitioningScheme().getPartitioning().getColumns());
        exchangeNode.getPartitioningScheme().getHashColumn().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        exchangeNode.getOrderingScheme().ifPresent(orderingScheme -> builder.addAll(orderingScheme.getOrderBy()));
        ImmutableSet outputsToRetain = builder.build();
        if (outputsToRetain.size() == exchangeNode.getOutputSymbols().size()) {
            return Optional.empty();
        }
        ImmutableList.Builder newOutputs = ImmutableList.builder();
        ArrayList<List<Symbol>> newInputs = new ArrayList<List<Symbol>>(exchangeNode.getInputs().size());
        for (i = 0; i < exchangeNode.getInputs().size(); ++i) {
            newInputs.add(new ArrayList());
        }
        for (i = 0; i < exchangeNode.getOutputSymbols().size(); ++i) {
            Symbol output = exchangeNode.getOutputSymbols().get(i);
            if (!outputsToRetain.contains(output)) continue;
            newOutputs.add((Object)output);
            for (int source = 0; source < exchangeNode.getInputs().size(); ++source) {
                ((List)newInputs.get(source)).add(exchangeNode.getInputs().get(source).get(i));
            }
        }
        PartitioningScheme newPartitioningScheme = new PartitioningScheme(exchangeNode.getPartitioningScheme().getPartitioning(), (List<Symbol>)newOutputs.build(), exchangeNode.getPartitioningScheme().getHashColumn(), exchangeNode.getPartitioningScheme().isReplicateNullsAndAny(), exchangeNode.getPartitioningScheme().getBucketToPartition());
        return Optional.of(new ExchangeNode(exchangeNode.getId(), exchangeNode.getType(), exchangeNode.getScope(), newPartitioningScheme, exchangeNode.getSources(), newInputs, exchangeNode.getOrderingScheme()));
    }
}

