/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;

public final class PushRemoteExchangeThroughAssignUniqueId
implements Rule<ExchangeNode> {
    private static final Capture<AssignUniqueId> ASSIGN_UNIQUE_ID = Capture.newCapture();
    private static final Pattern<ExchangeNode> PATTERN = Patterns.exchange().matching(exchange -> exchange.getScope() == ExchangeNode.Scope.REMOTE).matching(exchange -> exchange.getType() != ExchangeNode.Type.REPLICATE).with(Patterns.source().matching(Patterns.assignUniqueId().capturedAs(ASSIGN_UNIQUE_ID)));

    @Override
    public Pattern<ExchangeNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ExchangeNode node, Captures captures, Rule.Context context) {
        Preconditions.checkArgument((boolean)node.getOrderingScheme().isEmpty(), (Object)"Merge exchange over AssignUniqueId not supported");
        AssignUniqueId assignUniqueId = (AssignUniqueId)captures.get(ASSIGN_UNIQUE_ID);
        PartitioningScheme partitioningScheme = node.getPartitioningScheme();
        if (partitioningScheme.getPartitioning().getColumns().contains(assignUniqueId.getIdColumn())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new AssignUniqueId(assignUniqueId.getId(), new ExchangeNode(node.getId(), node.getType(), node.getScope(), new PartitioningScheme(partitioningScheme.getPartitioning(), PushRemoteExchangeThroughAssignUniqueId.removeSymbol(partitioningScheme.getOutputLayout(), assignUniqueId.getIdColumn()), partitioningScheme.getHashColumn(), partitioningScheme.isReplicateNullsAndAny(), partitioningScheme.getBucketToPartition()), (List<PlanNode>)ImmutableList.of((Object)assignUniqueId.getSource()), (List<List<Symbol>>)ImmutableList.of(PushRemoteExchangeThroughAssignUniqueId.removeSymbol((List)Iterables.getOnlyElement(node.getInputs()), assignUniqueId.getIdColumn())), Optional.empty()), assignUniqueId.getIdColumn()));
    }

    private static List<Symbol> removeSymbol(List<Symbol> symbols, Symbol symbolToRemove) {
        return (List)symbols.stream().filter(symbol -> !symbolToRemove.equals(symbol)).collect(ImmutableList.toImmutableList());
    }
}

