/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.spi.connector.LocalProperty;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.optimizations.LocalProperties;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

class PreferredProperties {
    private final Optional<Global> globalProperties;
    private final List<LocalProperty<Symbol>> localProperties;

    private PreferredProperties(Optional<Global> globalProperties, List<? extends LocalProperty<Symbol>> localProperties) {
        Objects.requireNonNull(globalProperties, "globalProperties is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        this.globalProperties = globalProperties;
        this.localProperties = ImmutableList.copyOf(localProperties);
    }

    public static PreferredProperties any() {
        return PreferredProperties.builder().build();
    }

    public static PreferredProperties undistributed() {
        return PreferredProperties.builder().global(Global.undistributed()).build();
    }

    public static PreferredProperties partitioned(Set<Symbol> columns) {
        return PreferredProperties.builder().global(Global.distributed(PartitioningProperties.partitioned(columns))).build();
    }

    public static PreferredProperties partitionedWithNullsAndAnyReplicated(Set<Symbol> columns) {
        return PreferredProperties.builder().global(Global.distributed(PartitioningProperties.partitioned(columns).withNullsAndAnyReplicated(true))).build();
    }

    public static PreferredProperties distributed() {
        return PreferredProperties.builder().global(Global.distributed()).build();
    }

    public static PreferredProperties partitioned(Partitioning partitioning) {
        return PreferredProperties.builder().global(Global.distributed(PartitioningProperties.partitioned(partitioning))).build();
    }

    public static PreferredProperties partitionedWithNullsAndAnyReplicated(Partitioning partitioning) {
        return PreferredProperties.builder().global(Global.distributed(PartitioningProperties.partitioned(partitioning).withNullsAndAnyReplicated(true))).build();
    }

    public static PreferredProperties partitionedWithLocal(Set<Symbol> columns, List<? extends LocalProperty<Symbol>> localProperties) {
        return PreferredProperties.builder().global(Global.distributed(PartitioningProperties.partitioned(columns))).local(localProperties).build();
    }

    public static PreferredProperties undistributedWithLocal(List<? extends LocalProperty<Symbol>> localProperties) {
        return PreferredProperties.builder().global(Global.undistributed()).local(localProperties).build();
    }

    public static PreferredProperties local(List<? extends LocalProperty<Symbol>> localProperties) {
        return PreferredProperties.builder().local(localProperties).build();
    }

    public Optional<Global> getGlobalProperties() {
        return this.globalProperties;
    }

    public List<LocalProperty<Symbol>> getLocalProperties() {
        return this.localProperties;
    }

    public PreferredProperties mergeWithParent(PreferredProperties parent) {
        ImmutableList newLocal = ImmutableList.builder().addAll(this.localProperties).addAll(parent.getLocalProperties()).build();
        Builder builder = PreferredProperties.builder().local((List<? extends LocalProperty<Symbol>>)newLocal);
        if (this.globalProperties.isPresent()) {
            Global currentGlobal = this.globalProperties.get();
            Global newGlobal = parent.getGlobalProperties().map(currentGlobal::mergeWithParent).orElse(currentGlobal);
            builder.global(newGlobal);
        } else {
            builder.global(parent.getGlobalProperties());
        }
        return builder.build();
    }

    public PreferredProperties translate(Function<Symbol, Optional<Symbol>> translator) {
        Optional<Global> newGlobalProperties = this.globalProperties.map(global -> global.translate(translator));
        List<LocalProperty<Symbol>> newLocalProperties = LocalProperties.translate(this.localProperties, translator);
        return new PreferredProperties(newGlobalProperties, newLocalProperties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<Global> globalProperties = Optional.empty();
        private List<LocalProperty<Symbol>> localProperties = ImmutableList.of();

        public Builder global(Global globalProperties) {
            this.globalProperties = Optional.of(globalProperties);
            return this;
        }

        public Builder global(Optional<Global> globalProperties) {
            this.globalProperties = globalProperties;
            return this;
        }

        public Builder global(PreferredProperties other) {
            this.globalProperties = other.globalProperties;
            return this;
        }

        public Builder local(List<? extends LocalProperty<Symbol>> localProperties) {
            this.localProperties = ImmutableList.copyOf(localProperties);
            return this;
        }

        public Builder local(PreferredProperties other) {
            this.localProperties = ImmutableList.copyOf(other.localProperties);
            return this;
        }

        public PreferredProperties build() {
            return new PreferredProperties(this.globalProperties, this.localProperties);
        }
    }

    @Immutable
    public static final class Global {
        private final boolean distributed;
        private final Optional<PartitioningProperties> partitioningProperties;

        private Global(boolean distributed, Optional<PartitioningProperties> partitioningProperties) {
            this.distributed = distributed;
            this.partitioningProperties = Objects.requireNonNull(partitioningProperties, "partitioningProperties is null");
        }

        public static Global undistributed() {
            return new Global(false, Optional.of(PartitioningProperties.singlePartition()));
        }

        public static Global distributed(Optional<PartitioningProperties> partitioningProperties) {
            return new Global(true, partitioningProperties);
        }

        public static Global distributed() {
            return Global.distributed(Optional.empty());
        }

        public static Global distributed(PartitioningProperties partitioning) {
            return Global.distributed(Optional.of(partitioning));
        }

        public boolean isDistributed() {
            return this.distributed;
        }

        public Optional<PartitioningProperties> getPartitioningProperties() {
            return this.partitioningProperties;
        }

        public Global mergeWithParent(Global parent) {
            if (this.distributed != parent.distributed) {
                return this;
            }
            if (this.partitioningProperties.isEmpty()) {
                return parent;
            }
            if (parent.partitioningProperties.isEmpty()) {
                return this;
            }
            return new Global(this.distributed, Optional.of(this.partitioningProperties.get().mergeWithParent(parent.partitioningProperties.get())));
        }

        public Global translate(Function<Symbol, Optional<Symbol>> translator) {
            if (!this.isDistributed()) {
                return this;
            }
            return Global.distributed(this.partitioningProperties.flatMap(properties -> properties.translate(translator)));
        }

        public int hashCode() {
            return Objects.hash(this.distributed, this.partitioningProperties);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Global other = (Global)obj;
            return Objects.equals(this.distributed, other.distributed) && Objects.equals(this.partitioningProperties, other.partitioningProperties);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("distributed", this.distributed).add("partitioningProperties", this.partitioningProperties).toString();
        }
    }

    @Immutable
    public static final class PartitioningProperties {
        private final Set<Symbol> partitioningColumns;
        private final Optional<Partitioning> partitioning;
        private final boolean nullsAndAnyReplicated;

        private PartitioningProperties(Set<Symbol> partitioningColumns, Optional<Partitioning> partitioning, boolean nullsAndAnyReplicated) {
            this.partitioningColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
            this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
            this.nullsAndAnyReplicated = nullsAndAnyReplicated;
            Preconditions.checkArgument((partitioning.isEmpty() || partitioning.get().getColumns().equals(partitioningColumns) ? 1 : 0) != 0, (Object)"Partitioning input must match partitioningColumns");
        }

        public PartitioningProperties withNullsAndAnyReplicated(boolean nullsAndAnyReplicated) {
            return new PartitioningProperties(this.partitioningColumns, this.partitioning, nullsAndAnyReplicated);
        }

        public static PartitioningProperties partitioned(Partitioning partitioning) {
            return new PartitioningProperties(partitioning.getColumns(), Optional.of(partitioning), false);
        }

        public static PartitioningProperties partitioned(Set<Symbol> columns) {
            return new PartitioningProperties(columns, Optional.empty(), false);
        }

        public static PartitioningProperties singlePartition() {
            return PartitioningProperties.partitioned((Set<Symbol>)ImmutableSet.of());
        }

        public Set<Symbol> getPartitioningColumns() {
            return this.partitioningColumns;
        }

        public Optional<Partitioning> getPartitioning() {
            return this.partitioning;
        }

        public boolean isNullsAndAnyReplicated() {
            return this.nullsAndAnyReplicated;
        }

        public PartitioningProperties mergeWithParent(PartitioningProperties parent) {
            if (this.partitioning.isPresent()) {
                return this;
            }
            if (this.nullsAndAnyReplicated != parent.nullsAndAnyReplicated) {
                return this;
            }
            if (parent.partitioning.isPresent()) {
                return this.partitioningColumns.containsAll(parent.partitioningColumns) ? parent : this;
            }
            Sets.SetView common = Sets.intersection(this.partitioningColumns, parent.partitioningColumns);
            return common.isEmpty() ? this : PartitioningProperties.partitioned((Set<Symbol>)common).withNullsAndAnyReplicated(this.nullsAndAnyReplicated);
        }

        public Optional<PartitioningProperties> translate(Function<Symbol, Optional<Symbol>> translator) {
            Set newPartitioningColumns = (Set)this.partitioningColumns.stream().map(translator).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet());
            if (!this.partitioningColumns.isEmpty() && newPartitioningColumns.isEmpty()) {
                return Optional.empty();
            }
            if (this.partitioning.isEmpty()) {
                return Optional.of(new PartitioningProperties(newPartitioningColumns, Optional.empty(), this.nullsAndAnyReplicated));
            }
            Optional<Partitioning> newPartitioning = this.partitioning.get().translate(new Partitioning.Translator(translator, symbol -> Optional.empty(), coalesceSymbols -> Optional.empty()));
            if (newPartitioning.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new PartitioningProperties(newPartitioningColumns, newPartitioning, this.nullsAndAnyReplicated));
        }

        public int hashCode() {
            return Objects.hash(this.partitioningColumns, this.partitioning, this.nullsAndAnyReplicated);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PartitioningProperties other = (PartitioningProperties)obj;
            return Objects.equals(this.partitioningColumns, other.partitioningColumns) && Objects.equals(this.partitioning, other.partitioning) && this.nullsAndAnyReplicated == other.nullsAndAnyReplicated;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitioningColumns", this.partitioningColumns).add("partitioning", this.partitioning).add("nullsAndAnyReplicated", this.nullsAndAnyReplicated).toString();
        }
    }
}

