/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.airlift.concurrent.MoreFutures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;

public final class Executors {
    private Executors() {
    }

    public static <T> void executeUntilFailure(Executor executor, Collection<Callable<T>> tasks) {
        ExecutorCompletionService<T> completionService = new ExecutorCompletionService<T>(executor);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            futures.add(completionService.submit(task));
        }
        try {
            for (int i = 0; i < futures.size(); ++i) {
                MoreFutures.getDone(Executors.take(completionService));
            }
        }
        catch (Exception failure) {
            try {
                futures.forEach(future -> future.cancel(true));
            }
            catch (RuntimeException e) {
                failure.addSuppressed(e);
            }
            throw failure;
        }
    }

    private static <T> Future<T> take(CompletionService<T> completionService) {
        try {
            return completionService.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted", e);
        }
    }
}

