/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class EnvoyProtoData {
    private EnvoyProtoData() {
    }

    private static Value convertToValue(Object rawObject) {
        Value.Builder valueBuilder = Value.newBuilder();
        if (rawObject == null) {
            valueBuilder.setNullValue(NullValue.NULL_VALUE);
        } else if (rawObject instanceof Double) {
            valueBuilder.setNumberValue(((Double)rawObject).doubleValue());
        } else if (rawObject instanceof String) {
            valueBuilder.setStringValue((String)rawObject);
        } else if (rawObject instanceof Boolean) {
            valueBuilder.setBoolValue(((Boolean)rawObject).booleanValue());
        } else if (rawObject instanceof Map) {
            Struct.Builder structBuilder = Struct.newBuilder();
            Map map = (Map)rawObject;
            for (Map.Entry entry : map.entrySet()) {
                structBuilder.putFields((String)entry.getKey(), EnvoyProtoData.convertToValue(entry.getValue()));
            }
            valueBuilder.setStructValue(structBuilder);
        } else if (rawObject instanceof List) {
            ListValue.Builder listBuilder = ListValue.newBuilder();
            List list = (List)rawObject;
            for (Object obj : list) {
                listBuilder.addValues(EnvoyProtoData.convertToValue(obj));
            }
            valueBuilder.setListValue(listBuilder);
        }
        return valueBuilder.build();
    }

    static final class Address {
        private final String address;
        private final int port;

        Address(String address, int port) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.port = port;
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address toEnvoyProtoAddress() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address.newBuilder().setSocketAddress(io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress.newBuilder().setAddress(this.address).setPortValue(this.port)).build();
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Address toEnvoyProtoAddressV2() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Address.newBuilder().setSocketAddress(SocketAddress.newBuilder().setAddress(this.address).setPortValue(this.port)).build();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("port", this.port).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Address address1 = (Address)o;
            return this.port == address1.port && Objects.equals(this.address, address1.address);
        }

        public int hashCode() {
            return Objects.hash(this.address, this.port);
        }
    }

    public static final class Node {
        private final String id;
        private final String cluster;
        @Nullable
        private final Map<String, ?> metadata;
        @Nullable
        private final io.grpc.xds.Locality locality;
        private final List<Address> listeningAddresses;
        private final String buildVersion;
        private final String userAgentName;
        @Nullable
        private final String userAgentVersion;
        private final List<String> clientFeatures;

        private Node(String id, String cluster, @Nullable Map<String, ?> metadata, @Nullable io.grpc.xds.Locality locality, List<Address> listeningAddresses, String buildVersion, String userAgentName, @Nullable String userAgentVersion, List<String> clientFeatures) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.cluster = (String)Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
            this.metadata = metadata;
            this.locality = locality;
            this.listeningAddresses = Collections.unmodifiableList((List)Preconditions.checkNotNull(listeningAddresses, (Object)"listeningAddresses"));
            this.buildVersion = (String)Preconditions.checkNotNull((Object)buildVersion, (Object)"buildVersion");
            this.userAgentName = (String)Preconditions.checkNotNull((Object)userAgentName, (Object)"userAgentName");
            this.userAgentVersion = userAgentVersion;
            this.clientFeatures = Collections.unmodifiableList((List)Preconditions.checkNotNull(clientFeatures, (Object)"clientFeatures"));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("cluster", (Object)this.cluster).add("metadata", this.metadata).add("locality", (Object)this.locality).add("listeningAddresses", this.listeningAddresses).add("buildVersion", (Object)this.buildVersion).add("userAgentName", (Object)this.userAgentName).add("userAgentVersion", (Object)this.userAgentVersion).add("clientFeatures", this.clientFeatures).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.id, node.id) && Objects.equals(this.cluster, node.cluster) && Objects.equals(this.metadata, node.metadata) && Objects.equals(this.locality, node.locality) && Objects.equals(this.listeningAddresses, node.listeningAddresses) && Objects.equals(this.buildVersion, node.buildVersion) && Objects.equals(this.userAgentName, node.userAgentName) && Objects.equals(this.userAgentVersion, node.userAgentVersion) && Objects.equals(this.clientFeatures, node.clientFeatures);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.cluster, this.metadata, this.locality, this.listeningAddresses, this.buildVersion, this.userAgentName, this.userAgentVersion, this.clientFeatures);
        }

        static Builder newBuilder() {
            return new Builder();
        }

        Builder toBuilder() {
            Builder builder = new Builder();
            builder.id = this.id;
            builder.cluster = this.cluster;
            builder.metadata = this.metadata;
            builder.locality = this.locality;
            builder.buildVersion = this.buildVersion;
            builder.listeningAddresses.addAll(this.listeningAddresses);
            builder.userAgentName = this.userAgentName;
            builder.userAgentVersion = this.userAgentVersion;
            builder.clientFeatures.addAll(this.clientFeatures);
            return builder;
        }

        String getId() {
            return this.id;
        }

        String getCluster() {
            return this.cluster;
        }

        @Nullable
        Map<String, ?> getMetadata() {
            return this.metadata;
        }

        @Nullable
        io.grpc.xds.Locality getLocality() {
            return this.locality;
        }

        List<Address> getListeningAddresses() {
            return this.listeningAddresses;
        }

        @VisibleForTesting
        public io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node toEnvoyProtoNode() {
            Node.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node.newBuilder();
            builder.setId(this.id);
            builder.setCluster(this.cluster);
            if (this.metadata != null) {
                Struct.Builder structBuilder = Struct.newBuilder();
                for (Map.Entry<String, ?> entry : this.metadata.entrySet()) {
                    structBuilder.putFields(entry.getKey(), EnvoyProtoData.convertToValue(entry.getValue()));
                }
                builder.setMetadata(structBuilder);
            }
            if (this.locality != null) {
                builder.setLocality(Locality.newBuilder().setRegion(this.locality.region()).setZone(this.locality.zone()).setSubZone(this.locality.subZone()));
            }
            for (Address address : this.listeningAddresses) {
                builder.addListeningAddresses(address.toEnvoyProtoAddress());
            }
            builder.setUserAgentName(this.userAgentName);
            if (this.userAgentVersion != null) {
                builder.setUserAgentVersion(this.userAgentVersion);
            }
            builder.addAllClientFeatures(this.clientFeatures);
            return builder.build();
        }

        static final class Builder {
            private String id = "";
            private String cluster = "";
            @Nullable
            private Map<String, ?> metadata;
            @Nullable
            private io.grpc.xds.Locality locality;
            private final List<Address> listeningAddresses = new ArrayList<Address>();
            private String buildVersion = "";
            private String userAgentName = "";
            @Nullable
            private String userAgentVersion;
            private final List<String> clientFeatures = new ArrayList<String>();

            private Builder() {
            }

            Builder setId(String id) {
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
                return this;
            }

            Builder setCluster(String cluster) {
                this.cluster = (String)Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
                return this;
            }

            Builder setMetadata(Map<String, ?> metadata) {
                this.metadata = (Map)Preconditions.checkNotNull(metadata, (Object)"metadata");
                return this;
            }

            Builder setLocality(io.grpc.xds.Locality locality) {
                this.locality = (io.grpc.xds.Locality)Preconditions.checkNotNull((Object)locality, (Object)"locality");
                return this;
            }

            Builder addListeningAddresses(Address address) {
                this.listeningAddresses.add((Address)Preconditions.checkNotNull((Object)address, (Object)"address"));
                return this;
            }

            Builder setBuildVersion(String buildVersion) {
                this.buildVersion = (String)Preconditions.checkNotNull((Object)buildVersion, (Object)"buildVersion");
                return this;
            }

            Builder setUserAgentName(String userAgentName) {
                this.userAgentName = (String)Preconditions.checkNotNull((Object)userAgentName, (Object)"userAgentName");
                return this;
            }

            Builder setUserAgentVersion(String userAgentVersion) {
                this.userAgentVersion = (String)Preconditions.checkNotNull((Object)userAgentVersion, (Object)"userAgentVersion");
                return this;
            }

            Builder addClientFeatures(String clientFeature) {
                this.clientFeatures.add((String)Preconditions.checkNotNull((Object)clientFeature, (Object)"clientFeature"));
                return this;
            }

            Node build() {
                return new Node(this.id, this.cluster, this.metadata, this.locality, this.listeningAddresses, this.buildVersion, this.userAgentName, this.userAgentVersion, this.clientFeatures);
            }
        }
    }
}

