/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.util.DLUtils;

class MaxLogSegmentSequenceNo {
    Version version;
    long maxSeqNo;

    MaxLogSegmentSequenceNo(Versioned<byte[]> logSegmentsData) {
        if (null != logSegmentsData && null != logSegmentsData.getValue() && null != logSegmentsData.getVersion()) {
            this.version = logSegmentsData.getVersion();
            try {
                this.maxSeqNo = DLUtils.deserializeLogSegmentSequenceNumber((byte[])logSegmentsData.getValue());
            }
            catch (NumberFormatException nfe) {
                this.maxSeqNo = 0L;
            }
        } else {
            this.maxSeqNo = 0L;
            if (null != logSegmentsData && null != logSegmentsData.getVersion()) {
                this.version = logSegmentsData.getVersion();
            } else {
                throw new IllegalStateException("Invalid MaxLogSegmentSequenceNo found - " + logSegmentsData);
            }
        }
    }

    synchronized Version getVersion() {
        return this.version;
    }

    synchronized long getSequenceNumber() {
        return this.maxSeqNo;
    }

    synchronized MaxLogSegmentSequenceNo update(Version version, long logSegmentSeqNo) {
        if (version.compare(this.version) == Version.Occurred.AFTER) {
            this.version = version;
            this.maxSeqNo = logSegmentSeqNo;
        }
        return this;
    }

    public synchronized Versioned<Long> getVersionedData(long seqNo) {
        return new Versioned((Object)seqNo, this.version);
    }
}

