/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.grpc.handler;

import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.function.BiConsumer;

public abstract class ResponseHandler<RespT>
implements BiConsumer<RespT, Throwable> {
    protected final StreamObserver<RespT> respObserver;

    protected ResponseHandler(StreamObserver<RespT> respObserver) {
        this.respObserver = respObserver;
    }

    protected abstract RespT createErrorResp(Throwable var1);

    @Override
    public void accept(RespT respT, Throwable cause) {
        if (null != cause) {
            if (cause instanceof StatusRuntimeException || cause instanceof StatusException) {
                this.respObserver.onError(cause);
                return;
            }
            this.respObserver.onNext(this.createErrorResp(cause));
        } else {
            this.respObserver.onNext(respT);
        }
        this.respObserver.onCompleted();
    }
}

