/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.pulsar.common.api.proto.AuthData;
import org.apache.pulsar.common.api.proto.LightProtoCodec;

public final class CommandAuthResponse {
    private String clientVersion;
    private int _clientVersionBufferIdx = -1;
    private int _clientVersionBufferLen = -1;
    private static final int _CLIENT_VERSION_FIELD_NUMBER = 1;
    private static final int _CLIENT_VERSION_TAG = 10;
    private static final int _CLIENT_VERSION_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _CLIENT_VERSION_MASK = 1;
    private AuthData response;
    private static final int _RESPONSE_FIELD_NUMBER = 2;
    private static final int _RESPONSE_TAG = 18;
    private static final int _RESPONSE_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private static final int _RESPONSE_MASK = 2;
    private int protocolVersion = 0;
    private static final int _PROTOCOL_VERSION_FIELD_NUMBER = 3;
    private static final int _PROTOCOL_VERSION_TAG = 24;
    private static final int _PROTOCOL_VERSION_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _PROTOCOL_VERSION_MASK = 4;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 0;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasClientVersion() {
        return (this._bitField0 & 1) != 0;
    }

    public String getClientVersion() {
        if (!this.hasClientVersion()) {
            throw new IllegalStateException("Field 'client_version' is not set");
        }
        if (this.clientVersion == null) {
            this.clientVersion = LightProtoCodec.readString(this._parsedBuffer, this._clientVersionBufferIdx, this._clientVersionBufferLen);
        }
        return this.clientVersion;
    }

    public CommandAuthResponse setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        this._bitField0 |= 1;
        this._clientVersionBufferIdx = -1;
        this._clientVersionBufferLen = LightProtoCodec.computeStringUTF8Size(clientVersion);
        this._cachedSize = -1;
        return this;
    }

    public CommandAuthResponse clearClientVersion() {
        this._bitField0 &= 0xFFFFFFFE;
        this.clientVersion = null;
        this._clientVersionBufferIdx = -1;
        this._clientVersionBufferLen = -1;
        return this;
    }

    public boolean hasResponse() {
        return (this._bitField0 & 2) != 0;
    }

    public AuthData getResponse() {
        if (!this.hasResponse()) {
            throw new IllegalStateException("Field 'response' is not set");
        }
        return this.response;
    }

    public AuthData setResponse() {
        if (this.response == null) {
            this.response = new AuthData();
        }
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this.response;
    }

    public CommandAuthResponse clearResponse() {
        this._bitField0 &= 0xFFFFFFFD;
        if (this.hasResponse()) {
            this.response.clear();
        }
        return this;
    }

    public boolean hasProtocolVersion() {
        return (this._bitField0 & 4) != 0;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public CommandAuthResponse setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public CommandAuthResponse clearProtocolVersion() {
        this._bitField0 &= 0xFFFFFFFB;
        this.protocolVersion = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        int _writeIdx = _b.writerIndex();
        if (this.hasClientVersion()) {
            LightProtoCodec.writeVarInt(_b, 10);
            LightProtoCodec.writeVarInt(_b, this._clientVersionBufferLen);
            if (this._clientVersionBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.clientVersion, this._clientVersionBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._clientVersionBufferIdx, _b, this._clientVersionBufferLen);
            }
        }
        if (this.hasResponse()) {
            LightProtoCodec.writeVarInt(_b, 18);
            LightProtoCodec.writeVarInt(_b, this.response.getSerializedSize());
            this.response.writeTo(_b);
        }
        if (this.hasProtocolVersion()) {
            LightProtoCodec.writeVarInt(_b, 24);
            LightProtoCodec.writeVarInt(_b, this.protocolVersion);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        if (this.hasClientVersion()) {
            _size += _CLIENT_VERSION_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._clientVersionBufferLen);
            _size += this._clientVersionBufferLen;
        }
        if (this.hasResponse()) {
            _size += LightProtoCodec.computeVarIntSize(18);
            int MsgsizeResponse = this.response.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeResponse) + MsgsizeResponse;
        }
        if (this.hasProtocolVersion()) {
            _size += _PROTOCOL_VERSION_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.protocolVersion);
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block5: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._clientVersionBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._clientVersionBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._clientVersionBufferLen);
                    continue block5;
                }
                case 18: {
                    this._bitField0 |= 2;
                    int responseSize = LightProtoCodec.readVarInt(_buffer);
                    this.setResponse().parseFrom(_buffer, responseSize);
                    continue block5;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.protocolVersion = LightProtoCodec.readVarInt(_buffer);
                    continue block5;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this._parsedBuffer = _buffer;
    }

    public CommandAuthResponse clear() {
        this.clientVersion = null;
        this._clientVersionBufferIdx = -1;
        this._clientVersionBufferLen = -1;
        if (this.hasResponse()) {
            this.response.clear();
        }
        this.protocolVersion = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandAuthResponse copyFrom(CommandAuthResponse _other) {
        this._cachedSize = -1;
        if (_other.hasClientVersion()) {
            this.setClientVersion(_other.getClientVersion());
        }
        if (_other.hasResponse()) {
            this.setResponse().copyFrom(_other.response);
        }
        if (_other.hasProtocolVersion()) {
            this.setProtocolVersion(_other.protocolVersion);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }
}

