/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import io.trino.cli.TerminalUtils;
import java.io.PrintStream;
import java.util.Objects;

public class ConsolePrinter {
    private static final String ERASE_SCREEN_FORWARD = "\u001b[0J";
    private static final String ERASE_LINE_ALL = "\u001b[2K";
    private final PrintStream out;
    private int lines;

    public ConsolePrinter(PrintStream out) {
        this.out = Objects.requireNonNull(out, "out is null");
    }

    public void reprintLine(String line) {
        if (TerminalUtils.isRealTerminal()) {
            this.out.print(ERASE_LINE_ALL + line + "\n");
        } else {
            this.out.print('\r' + line);
        }
        this.out.flush();
        ++this.lines;
    }

    public void repositionCursor() {
        if (this.lines > 0) {
            if (TerminalUtils.isRealTerminal()) {
                this.out.print(ConsolePrinter.cursorUp(this.lines));
            } else {
                this.out.print('\r');
            }
            this.out.flush();
            this.lines = 0;
        }
    }

    public void resetScreen() {
        if (this.lines > 0) {
            if (TerminalUtils.isRealTerminal()) {
                this.out.print(ConsolePrinter.cursorUp(this.lines) + ERASE_SCREEN_FORWARD);
            } else {
                this.out.print('\r');
            }
            this.out.flush();
            this.lines = 0;
        }
    }

    private static String cursorUp(int lines) {
        return "\u001b[" + lines + "A";
    }
}

