/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.channel;

import java.util.Map;
import java.util.Set;

public enum ServiceUnitState {
    Init,
    Free,
    Owned,
    Assigning,
    Releasing,
    Splitting,
    Deleted;

    private static final Map<ServiceUnitState, Set<ServiceUnitState>> validTransitions;
    private static final Set<ServiceUnitState> inFlightStates;

    public static boolean isValidTransition(ServiceUnitState from, ServiceUnitState to) {
        Set<ServiceUnitState> transitions = validTransitions.get((Object)from);
        return transitions.contains((Object)to);
    }

    public static boolean isInFlightState(ServiceUnitState state) {
        return inFlightStates.contains((Object)state);
    }

    public static boolean isActiveState(ServiceUnitState state) {
        return inFlightStates.contains((Object)state) || state == Owned;
    }

    static {
        validTransitions = Map.of(Init, Set.of(Free, Owned, Assigning, Releasing, Splitting, Deleted), Free, Set.of(Assigning, Init), Owned, Set.of(Splitting, Releasing), Assigning, Set.of(Owned), Releasing, Set.of(Assigning, Free), Splitting, Set.of(Deleted), Deleted, Set.of(Init));
        inFlightStates = Set.of(Assigning, Releasing, Splitting);
    }
}

