/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.common.api.proto.IntRange;
import org.apache.pulsar.common.util.FutureUtil;

public class HashRangeExclusiveStickyKeyConsumerSelector
implements StickyKeyConsumerSelector {
    private final int rangeSize;
    private final ConcurrentSkipListMap<Integer, Pair<Range, Consumer>> rangeMap;

    public HashRangeExclusiveStickyKeyConsumerSelector() {
        this(65536);
    }

    public HashRangeExclusiveStickyKeyConsumerSelector(int rangeSize) {
        if (rangeSize < 1) {
            throw new IllegalArgumentException("range size must greater than 0");
        }
        this.rangeSize = rangeSize;
        this.rangeMap = new ConcurrentSkipListMap();
    }

    @Override
    public synchronized CompletableFuture<Void> addConsumer(Consumer consumer) {
        return this.validateKeySharedMeta(consumer).thenRun(() -> {
            try {
                this.internalAddConsumer(consumer);
            }
            catch (BrokerServiceException.ConsumerAssignException e) {
                throw FutureUtil.wrapToCompletionException((Throwable)e);
            }
        });
    }

    private synchronized void internalAddConsumer(Consumer consumer) throws BrokerServiceException.ConsumerAssignException {
        Consumer conflictingConsumer = this.findConflictingConsumer(consumer.getKeySharedMeta().getHashRangesList());
        if (conflictingConsumer != null) {
            throw new BrokerServiceException.ConsumerAssignException("Range conflict with consumer " + String.valueOf(conflictingConsumer));
        }
        for (IntRange intRange : consumer.getKeySharedMeta().getHashRangesList()) {
            this.rangeMap.put(intRange.getStart(), (Pair<Range, Consumer>)Pair.of((Object)Range.of((int)intRange.getStart(), (int)intRange.getEnd()), (Object)consumer));
        }
    }

    @Override
    public void removeConsumer(Consumer consumer) {
        this.rangeMap.entrySet().removeIf(entry -> ((Consumer)((Pair)entry.getValue()).getRight()).equals(consumer));
    }

    @Override
    public Map<Consumer, List<Range>> getConsumerKeyHashRanges() {
        HashMap<Consumer, List<Range>> result = new HashMap<Consumer, List<Range>>();
        for (Map.Entry<Integer, Pair<Range, Consumer>> entry : this.rangeMap.entrySet()) {
            Range assignedRange = (Range)entry.getValue().getLeft();
            Consumer assignedConsumer = (Consumer)entry.getValue().getRight();
            result.computeIfAbsent(assignedConsumer, key -> new ArrayList()).add(assignedRange);
        }
        return result;
    }

    @Override
    public Consumer select(int hash) {
        if (this.rangeMap.isEmpty()) {
            return null;
        }
        int slot = hash % this.rangeSize;
        Map.Entry<Integer, Pair<Range, Consumer>> floorEntry = this.rangeMap.floorEntry(slot);
        if (floorEntry == null) {
            return null;
        }
        Pair<Range, Consumer> pair = floorEntry.getValue();
        if (((Range)pair.getLeft()).contains(slot)) {
            return (Consumer)pair.getRight();
        }
        return null;
    }

    private synchronized CompletableFuture<Void> validateKeySharedMeta(Consumer consumer) {
        if (consumer.getKeySharedMeta() == null) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerAssignException("Must specify key shared meta for consumer."));
        }
        List ranges = consumer.getKeySharedMeta().getHashRangesList();
        if (ranges.isEmpty()) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerAssignException("Ranges for KeyShared policy must not be empty."));
        }
        ArrayList<IntRange> sortedRanges = new ArrayList<IntRange>(ranges);
        sortedRanges.sort(Comparator.comparingInt(IntRange::getStart));
        for (int i = 0; i < sortedRanges.size(); ++i) {
            IntRange nextRange;
            IntRange currentRange = (IntRange)sortedRanges.get(i);
            if (currentRange.getStart() > currentRange.getEnd()) {
                return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerAssignException("Fixed hash range start > end for range: [" + currentRange.getStart() + "," + currentRange.getEnd() + "]"));
            }
            if (i >= sortedRanges.size() - 1 || !HashRangeExclusiveStickyKeyConsumerSelector.areRangesOverlapping(currentRange, nextRange = (IntRange)sortedRanges.get(i + 1))) continue;
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerAssignException("Consumer's own ranges conflict: [" + currentRange.getStart() + "," + currentRange.getEnd() + "] overlaps with [" + nextRange.getStart() + "," + nextRange.getEnd() + "]"));
        }
        Consumer conflictingConsumer = this.findConflictingConsumer(ranges);
        if (conflictingConsumer != null) {
            return conflictingConsumer.cnx().checkConnectionLiveness().thenRun(() -> {});
        }
        return CompletableFuture.completedFuture(null);
    }

    private synchronized Consumer findConflictingConsumer(List<IntRange> newConsumerRanges) {
        for (IntRange newRange : newConsumerRanges) {
            Range existingRange;
            Range existingRange2;
            Map.Entry<Integer, Pair<Range, Consumer>> conflictBeforeStart = this.rangeMap.floorEntry(newRange.getStart());
            if (conflictBeforeStart != null && HashRangeExclusiveStickyKeyConsumerSelector.areRangesOverlapping(newRange, existingRange2 = (Range)conflictBeforeStart.getValue().getLeft())) {
                return (Consumer)conflictBeforeStart.getValue().getRight();
            }
            Map.Entry<Integer, Pair<Range, Consumer>> conflictAfterStart = this.rangeMap.ceilingEntry(newRange.getStart());
            if (conflictAfterStart == null || !HashRangeExclusiveStickyKeyConsumerSelector.areRangesOverlapping(newRange, existingRange = (Range)conflictAfterStart.getValue().getLeft())) continue;
            return (Consumer)conflictAfterStart.getValue().getRight();
        }
        return null;
    }

    private static boolean areRangesOverlapping(IntRange range1, Range range2) {
        return Math.max(range1.getStart(), range2.getStart()) <= Math.min(range1.getEnd(), range2.getEnd());
    }

    private static boolean areRangesOverlapping(IntRange range1, IntRange range2) {
        return Math.max(range1.getStart(), range2.getStart()) <= Math.min(range1.getEnd(), range2.getEnd());
    }

    Map<Integer, Pair<Range, Consumer>> getRangeConsumer() {
        return Collections.unmodifiableMap(this.rangeMap);
    }
}

