/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.client.HostProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public final class StaticHostProvider
implements HostProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHostProvider.class);
    private List<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>(5);
    private Random sourceOfRandomness;
    private int lastIndex = -1;
    private int currentIndex = -1;
    private boolean reconfigMode = false;
    private final List<InetSocketAddress> oldServers = new ArrayList<InetSocketAddress>(5);
    private final List<InetSocketAddress> newServers = new ArrayList<InetSocketAddress>(5);
    private int currentIndexOld = -1;
    private int currentIndexNew = -1;
    private float pOld;
    private float pNew;
    private Resolver resolver;

    public StaticHostProvider(Collection<InetSocketAddress> serverAddresses) {
        this.init(serverAddresses, System.currentTimeMillis() ^ (long)this.hashCode(), new Resolver(){

            @Override
            public InetAddress[] getAllByName(String name) throws UnknownHostException {
                return InetAddress.getAllByName(name);
            }
        });
    }

    public StaticHostProvider(Collection<InetSocketAddress> serverAddresses, Resolver resolver) {
        this.init(serverAddresses, System.currentTimeMillis() ^ (long)this.hashCode(), resolver);
    }

    public StaticHostProvider(Collection<InetSocketAddress> serverAddresses, long randomnessSeed) {
        this.init(serverAddresses, randomnessSeed, new Resolver(){

            @Override
            public InetAddress[] getAllByName(String name) throws UnknownHostException {
                return InetAddress.getAllByName(name);
            }
        });
    }

    private void init(Collection<InetSocketAddress> serverAddresses, long randomnessSeed, Resolver resolver) {
        this.sourceOfRandomness = new Random(randomnessSeed);
        this.resolver = resolver;
        if (serverAddresses.isEmpty()) {
            throw new IllegalArgumentException("A HostProvider may not be empty!");
        }
        this.serverAddresses = this.shuffle(serverAddresses);
        this.currentIndex = -1;
        this.lastIndex = -1;
    }

    private InetSocketAddress resolve(InetSocketAddress address) {
        try {
            String curHostString = address.getHostString();
            ArrayList<InetAddress> resolvedAddresses = new ArrayList<InetAddress>(Arrays.asList(this.resolver.getAllByName(curHostString)));
            if (resolvedAddresses.isEmpty()) {
                return address;
            }
            Collections.shuffle(resolvedAddresses);
            return new InetSocketAddress((InetAddress)resolvedAddresses.get(0), address.getPort());
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve address: {}", (Object)address.toString(), (Object)e);
            return address;
        }
    }

    private List<InetSocketAddress> shuffle(Collection<InetSocketAddress> serverAddresses) {
        ArrayList<InetSocketAddress> tmpList = new ArrayList<InetSocketAddress>(serverAddresses.size());
        tmpList.addAll(serverAddresses);
        Collections.shuffle(tmpList, this.sourceOfRandomness);
        return tmpList;
    }

    @Override
    public synchronized boolean updateServerList(Collection<InetSocketAddress> serverAddresses, InetSocketAddress currentHost) {
        int numNew;
        List<InetSocketAddress> shuffledList = this.shuffle(serverAddresses);
        if (shuffledList.isEmpty()) {
            throw new IllegalArgumentException("A HostProvider may not be empty!");
        }
        boolean myServerInNewConfig = false;
        InetSocketAddress myServer = currentHost;
        if (this.reconfigMode) {
            myServer = this.next(0L);
        }
        if (myServer == null) {
            myServer = this.lastIndex >= 0 ? this.serverAddresses.get(this.lastIndex) : this.serverAddresses.get(0);
        }
        for (InetSocketAddress addr : shuffledList) {
            if (addr.getPort() != myServer.getPort() || (addr.getAddress() == null || myServer.getAddress() == null || !addr.getAddress().equals(myServer.getAddress())) && !addr.getHostString().equals(myServer.getHostString())) continue;
            myServerInNewConfig = true;
            break;
        }
        this.reconfigMode = true;
        this.newServers.clear();
        this.oldServers.clear();
        for (InetSocketAddress address : shuffledList) {
            if (this.serverAddresses.contains(address)) {
                this.oldServers.add(address);
                continue;
            }
            this.newServers.add(address);
        }
        int numOld = this.oldServers.size();
        if (numOld + (numNew = this.newServers.size()) > this.serverAddresses.size()) {
            if (myServerInNewConfig) {
                if (this.sourceOfRandomness.nextFloat() <= 1.0f - (float)this.serverAddresses.size() / (float)(numOld + numNew)) {
                    this.pNew = 1.0f;
                    this.pOld = 0.0f;
                } else {
                    this.reconfigMode = false;
                }
            } else {
                this.pNew = 1.0f;
                this.pOld = 0.0f;
            }
        } else if (myServerInNewConfig) {
            this.reconfigMode = false;
        } else {
            this.pOld = (float)(numOld * (this.serverAddresses.size() - (numOld + numNew))) / (float)((numOld + numNew) * (this.serverAddresses.size() - numOld));
            this.pNew = 1.0f - this.pOld;
        }
        this.currentIndex = !this.reconfigMode ? shuffledList.indexOf(this.getServerAtCurrentIndex()) : -1;
        this.serverAddresses = shuffledList;
        this.currentIndexOld = -1;
        this.currentIndexNew = -1;
        this.lastIndex = this.currentIndex;
        return this.reconfigMode;
    }

    public synchronized InetSocketAddress getServerAtIndex(int i) {
        if (i < 0 || i >= this.serverAddresses.size()) {
            return null;
        }
        return this.serverAddresses.get(i);
    }

    public synchronized InetSocketAddress getServerAtCurrentIndex() {
        return this.getServerAtIndex(this.currentIndex);
    }

    @Override
    public synchronized int size() {
        return this.serverAddresses.size();
    }

    private InetSocketAddress nextHostInReconfigMode() {
        boolean takeNew;
        boolean bl = takeNew = this.sourceOfRandomness.nextFloat() <= this.pNew;
        if (this.currentIndexNew + 1 < this.newServers.size() && (takeNew || this.currentIndexOld + 1 >= this.oldServers.size())) {
            ++this.currentIndexNew;
            return this.newServers.get(this.currentIndexNew);
        }
        if (this.currentIndexOld + 1 < this.oldServers.size()) {
            ++this.currentIndexOld;
            return this.oldServers.get(this.currentIndexOld);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetSocketAddress next(long spinDelay) {
        InetSocketAddress addr;
        boolean needToSleep = false;
        StaticHostProvider staticHostProvider = this;
        synchronized (staticHostProvider) {
            if (this.reconfigMode) {
                addr = this.nextHostInReconfigMode();
                if (addr != null) {
                    this.currentIndex = this.serverAddresses.indexOf(addr);
                    return this.resolve(addr);
                }
                this.reconfigMode = false;
                needToSleep = spinDelay > 0L;
            }
            ++this.currentIndex;
            if (this.currentIndex == this.serverAddresses.size()) {
                this.currentIndex = 0;
            }
            addr = this.serverAddresses.get(this.currentIndex);
            boolean bl = needToSleep = needToSleep || this.currentIndex == this.lastIndex && spinDelay > 0L;
            if (this.lastIndex == -1) {
                this.lastIndex = 0;
            }
        }
        if (needToSleep) {
            try {
                Thread.sleep(spinDelay);
            }
            catch (InterruptedException e) {
                LOG.warn("Unexpected exception", (Throwable)e);
            }
        }
        return this.resolve(addr);
    }

    @Override
    public synchronized void onConnected() {
        this.lastIndex = this.currentIndex;
        this.reconfigMode = false;
    }

    public static interface Resolver {
        public InetAddress[] getAllByName(String var1) throws UnknownHostException;
    }
}

